/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import org.axonframework.messaging.Scope;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.SagaExecutionException;
import org.axonframework.modelling.saga.SagaScopeDescriptor;

public abstract class SagaLifecycle
extends Scope {
    public static void associateWith(String associationKey, String associationValue) {
        SagaLifecycle.associateWith(new AssociationValue(associationKey, associationValue));
    }

    public static void associateWith(String associationKey, Number associationValue) {
        SagaLifecycle.associateWith(new AssociationValue(associationKey, associationValue.toString()));
    }

    public static void associateWith(AssociationValue associationValue) {
        SagaLifecycle.getInstance().doAssociateWith(associationValue);
    }

    public static void removeAssociationWith(String associationKey, String associationValue) {
        SagaLifecycle.getInstance().doRemoveAssociation(new AssociationValue(associationKey, associationValue));
    }

    public static void removeAssociationWith(String associationKey, Number associationValue) {
        SagaLifecycle.removeAssociationWith(associationKey, associationValue.toString());
    }

    public static void end() {
        SagaLifecycle.getInstance().doEnd();
    }

    protected abstract void doEnd();

    protected abstract void doRemoveAssociation(AssociationValue var1);

    protected abstract void doAssociateWith(AssociationValue var1);

    protected static SagaLifecycle getInstance() {
        return (SagaLifecycle)Scope.getCurrentScope();
    }

    protected void execute(Runnable task) {
        try {
            this.executeWithResult(() -> {
                task.run();
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SagaExecutionException("Exception while executing a task for a saga", e);
        }
    }

    protected abstract String type();

    protected abstract String getSagaIdentifier();

    public ScopeDescriptor describeScope() {
        return new SagaScopeDescriptor(this.type(), this.getSagaIdentifier());
    }
}

