/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.concurrent.Callable;
import org.axonframework.common.Assert;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.modelling.command.AbstractRepository;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockingRepository<T, A extends Aggregate<T>>
extends AbstractRepository<T, LockAwareAggregate<T, A>> {
    private static final Logger logger = LoggerFactory.getLogger(LockingRepository.class);
    private final LockFactory lockFactory;

    protected LockingRepository(Builder<T> builder) {
        super(builder);
        this.lockFactory = ((Builder)builder).lockFactory;
    }

    @Override
    protected LockAwareAggregate<T, A> doCreateNew(Callable<T> factoryMethod) throws Exception {
        A aggregate = this.doCreateNewForLock(factoryMethod);
        String aggregateIdentifier = aggregate.identifierAsString();
        Lock lock = this.lockFactory.obtainLock(aggregateIdentifier);
        try {
            CurrentUnitOfWork.get().onCleanup(u -> lock.release());
        }
        catch (Throwable ex) {
            if (lock != null) {
                logger.debug("Exception occurred while trying to add an aggregate. Releasing lock.", ex);
                lock.release();
            }
            throw ex;
        }
        return new LockAwareAggregate(aggregate, lock);
    }

    protected abstract A doCreateNewForLock(Callable<T> var1) throws Exception;

    @Override
    protected LockAwareAggregate<T, A> doLoad(String aggregateIdentifier, Long expectedVersion) {
        Lock lock = this.lockFactory.obtainLock(aggregateIdentifier);
        try {
            A aggregate = this.doLoadWithLock(aggregateIdentifier, expectedVersion);
            CurrentUnitOfWork.get().onCleanup(u -> lock.release());
            return new LockAwareAggregate(aggregate, lock);
        }
        catch (Throwable ex) {
            logger.debug("Exception occurred while trying to load an aggregate. Releasing lock.", ex);
            lock.release();
            throw ex;
        }
    }

    @Override
    protected void prepareForCommit(LockAwareAggregate<T, A> aggregate) {
        Assert.state((boolean)aggregate.isLockHeld(), () -> "An aggregate is being used for which a lock is no longer held");
        super.prepareForCommit(aggregate);
    }

    @Override
    protected void doSave(LockAwareAggregate<T, A> aggregate) {
        if (aggregate.version() != null && !aggregate.isLockHeld()) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.identifierAsString()));
        }
        this.doSaveWithLock(aggregate.getWrappedAggregate());
    }

    @Override
    protected final void doDelete(LockAwareAggregate<T, A> aggregate) {
        if (aggregate.version() != null && !aggregate.isLockHeld()) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.identifierAsString()));
        }
        this.doDeleteWithLock(aggregate.getWrappedAggregate());
    }

    protected abstract void doSaveWithLock(A var1);

    protected abstract void doDeleteWithLock(A var1);

    protected abstract A doLoadWithLock(String var1, Long var2);

    protected static abstract class Builder<T>
    extends AbstractRepository.Builder<T> {
        private LockFactory lockFactory = new PessimisticLockFactory();

        protected Builder(Class<T> aggregateType) {
            super(aggregateType);
        }

        @Override
        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            super.parameterResolverFactory(parameterResolverFactory);
            return this;
        }

        @Override
        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            super.handlerDefinition(handlerDefinition);
            return this;
        }

        @Override
        public Builder<T> aggregateModel(AggregateModel<T> aggregateModel) {
            super.aggregateModel(aggregateModel);
            return this;
        }

        public Builder<T> lockFactory(LockFactory lockFactory) {
            BuilderUtils.assertNonNull((Object)lockFactory, (String)"LockFactory may not be null");
            this.lockFactory = lockFactory;
            return this;
        }
    }
}

