/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageTimerMonitor
implements MessageMonitor<Message<?>> {
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Clock clock;
    private final Function<Message<?>, Iterable<Tag>> tagsBuilder;
    private final UnaryOperator<Timer.Builder> timerCustomization;

    public static Builder builder() {
        return new Builder();
    }

    protected MessageTimerMonitor(Builder builder) {
        builder.validate();
        this.meterNamePrefix = builder.meterNamePrefix;
        this.meterRegistry = builder.meterRegistry;
        this.clock = builder.clock;
        this.tagsBuilder = builder.tagsBuilder;
        this.timerCustomization = builder.timerCustomization;
    }

    @Deprecated
    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, Clock.SYSTEM);
    }

    @Deprecated
    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, Clock.SYSTEM, tagsBuilder);
    }

    @Deprecated
    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, clock, message -> Tags.empty());
    }

    @Deprecated
    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return MessageTimerMonitor.builder().meterNamePrefix(meterNamePrefix).meterRegistry(meterRegistry).clock(clock).tagsBuilder(tagsBuilder).build();
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        Iterable<Tag> tags = this.tagsBuilder.apply(message);
        final Timer allTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "allTimer", this.meterRegistry, tags, this.timerCustomization);
        final Timer successTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "successTimer", this.meterRegistry, tags, this.timerCustomization);
        final Timer failureTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "failureTimer", this.meterRegistry, tags, this.timerCustomization);
        final Timer ignoredTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "ignoredTimer", this.meterRegistry, tags, this.timerCustomization);
        final long startTime = this.clock.monotonicTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                successTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportFailure(Throwable cause) {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                failureTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportIgnored() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                ignoredTimer.record(duration, TimeUnit.NANOSECONDS);
            }
        };
    }

    private static Timer buildTimer(String meterNamePrefix, String timerName, MeterRegistry meterRegistry, Iterable<Tag> tags, UnaryOperator<Timer.Builder> timerCustomization) {
        Timer.Builder timerBuilder = Timer.builder((String)(meterNamePrefix + "." + timerName)).distributionStatisticExpiry(Duration.of(10L, ChronoUnit.MINUTES)).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999}).tags(tags);
        return ((Timer.Builder)timerCustomization.apply(timerBuilder)).register(meterRegistry);
    }

    public static class Builder {
        private String meterNamePrefix;
        private MeterRegistry meterRegistry;
        private Clock clock = Clock.SYSTEM;
        private Function<Message<?>, Iterable<Tag>> tagsBuilder = message -> Tags.empty();
        private UnaryOperator<Timer.Builder> timerCustomization = timerBuilder -> timerBuilder;

        public Builder meterNamePrefix(String meterNamePrefix) {
            BuilderUtils.assertNonEmpty((String)meterNamePrefix, (String)"The meter name prefix may not be null or empty");
            this.meterNamePrefix = meterNamePrefix;
            return this;
        }

        public Builder meterRegistry(MeterRegistry meterRegistry) {
            BuilderUtils.assertNonNull((Object)meterRegistry, (String)"MeterRegistry may not be null");
            this.meterRegistry = meterRegistry;
            return this;
        }

        public Builder clock(Clock clock) {
            BuilderUtils.assertNonNull((Object)clock, (String)"Clock may not be null");
            this.clock = clock;
            return this;
        }

        public Builder tagsBuilder(Function<Message<?>, Iterable<Tag>> tagsBuilder) {
            BuilderUtils.assertNonNull(tagsBuilder, (String)"TagsBuilder may not be null");
            this.tagsBuilder = tagsBuilder;
            return this;
        }

        public Builder timerCustomization(UnaryOperator<Timer.Builder> timerCustomization) {
            BuilderUtils.assertNonNull(timerCustomization, (String)"TimerCustomization may not be null");
            this.timerCustomization = timerCustomization;
            return this;
        }

        public MessageTimerMonitor build() {
            return new MessageTimerMonitor(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty((String)this.meterNamePrefix, (String)"The meter name prefix is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.meterRegistry, (String)"The MeterRegistry is a hard requirement and should be provided");
        }
    }
}

