/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageTimerMonitor
implements MessageMonitor<Message<?>> {
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Function<Message<?>, Iterable<Tag>> tagsBuilder;
    private final Clock clock;

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, Clock.SYSTEM);
    }

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, Clock.SYSTEM, tagsBuilder);
    }

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock) {
        return new MessageTimerMonitor(meterNamePrefix, meterRegistry, clock);
    }

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return new MessageTimerMonitor(meterNamePrefix, meterRegistry, tagsBuilder, clock);
    }

    private static Timer buildTimer(String meterNamePrefix, String timerName, MeterRegistry meterRegistry, Iterable<Tag> tags) {
        return Timer.builder((String)(meterNamePrefix + "." + timerName)).distributionStatisticExpiry(Duration.of(10L, ChronoUnit.MINUTES)).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999}).tags(tags).register(meterRegistry);
    }

    private MessageTimerMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder, Clock clock) {
        this.meterNamePrefix = meterNamePrefix;
        this.meterRegistry = meterRegistry;
        this.tagsBuilder = tagsBuilder;
        this.clock = clock;
    }

    private MessageTimerMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock) {
        this(meterNamePrefix, meterRegistry, message -> Tags.empty(), clock);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        Iterable<Tag> tags = this.tagsBuilder.apply(message);
        final Timer allTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "allTimer", this.meterRegistry, tags);
        final Timer successTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "successTimer", this.meterRegistry, tags);
        final Timer failureTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "failureTimer", this.meterRegistry, tags);
        final Timer ignoredTimer = MessageTimerMonitor.buildTimer(this.meterNamePrefix, "ignoredTimer", this.meterRegistry, tags);
        final long startTime = this.clock.monotonicTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                successTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportFailure(Throwable cause) {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                failureTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportIgnored() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                allTimer.record(duration, TimeUnit.NANOSECONDS);
                ignoredTimer.record(duration, TimeUnit.NANOSECONDS);
            }
        };
    }
}

