/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>> {
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Function<Message<?>, Iterable<Tag>> tagsBuilder;
    private final AtomicLong lastReceivedTime = new AtomicLong(-1L);
    private final AtomicLong lastProcessedTime = new AtomicLong(-1L);

    private EventProcessorLatencyMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        this(meterNamePrefix, meterRegistry, message -> Tags.empty());
    }

    private EventProcessorLatencyMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        this.meterNamePrefix = meterNamePrefix;
        this.meterRegistry = meterRegistry;
        this.tagsBuilder = tagsBuilder;
    }

    public static EventProcessorLatencyMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return new EventProcessorLatencyMonitor(meterNamePrefix, meterRegistry);
    }

    public static EventProcessorLatencyMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return new EventProcessorLatencyMonitor(meterNamePrefix, meterRegistry, tagsBuilder);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(final EventMessage<?> message) {
        if (message == null) {
            return NoOpMessageMonitorCallback.INSTANCE;
        }
        Iterable<Tag> tags = this.tagsBuilder.apply((Message<?>)message);
        Gauge.builder((String)(this.meterNamePrefix + ".latency"), (Object)this, EventProcessorLatencyMonitor::calculateLatency).tags(tags).register(this.meterRegistry);
        this.updateIfMaxValue(this.lastReceivedTime, message.getTimestamp().toEpochMilli());
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                this.update();
            }

            public void reportFailure(Throwable cause) {
                this.update();
            }

            public void reportIgnored() {
                this.update();
            }

            private void update() {
                EventProcessorLatencyMonitor.this.updateIfMaxValue(EventProcessorLatencyMonitor.this.lastProcessedTime, message.getTimestamp().toEpochMilli());
            }
        };
    }

    private long calculateLatency() {
        long lastProcessedTime = this.lastProcessedTime.longValue();
        long lastReceivedTime = this.lastReceivedTime.longValue();
        long processTime = lastReceivedTime == -1L || lastProcessedTime == -1L ? 0L : lastReceivedTime - lastProcessedTime;
        return processTime;
    }

    private void updateIfMaxValue(AtomicLong atomicLong, long timestamp) {
        atomicLong.accumulateAndGet(timestamp, (currentValue, newValue) -> newValue > currentValue ? newValue : currentValue);
    }
}

