/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>> {
    private final AtomicLong lastReceivedTime = new AtomicLong(-1L);
    private final AtomicLong lastProcessedTime = new AtomicLong(-1L);

    private EventProcessorLatencyMonitor() {
    }

    public static EventProcessorLatencyMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        EventProcessorLatencyMonitor eventProcessorLatencyMonitor = new EventProcessorLatencyMonitor();
        Gauge.builder((String)(meterNamePrefix + ".latency"), (Object)eventProcessorLatencyMonitor, EventProcessorLatencyMonitor::calculateLatency).register(meterRegistry);
        return eventProcessorLatencyMonitor;
    }

    public MessageMonitor.MonitorCallback onMessageIngested(final EventMessage<?> message) {
        if (message == null) {
            return NoOpMessageMonitorCallback.INSTANCE;
        }
        this.updateIfMaxValue(this.lastReceivedTime, message.getTimestamp().toEpochMilli());
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                this.update();
            }

            public void reportFailure(Throwable cause) {
                this.update();
            }

            public void reportIgnored() {
                this.update();
            }

            private void update() {
                EventProcessorLatencyMonitor.this.updateIfMaxValue(EventProcessorLatencyMonitor.this.lastProcessedTime, message.getTimestamp().toEpochMilli());
            }
        };
    }

    private long calculateLatency() {
        long lastProcessedTime = this.lastProcessedTime.longValue();
        long lastReceivedTime = this.lastReceivedTime.longValue();
        long processTime = lastReceivedTime == -1L || lastProcessedTime == -1L ? 0L : lastReceivedTime - lastProcessedTime;
        return processTime;
    }

    private void updateIfMaxValue(AtomicLong atomicLong, long timestamp) {
        atomicLong.accumulateAndGet(timestamp, (currentValue, newValue) -> newValue > currentValue ? newValue : currentValue);
    }
}

