/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.config.Configurer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.messaging.Message;
import org.axonframework.micrometer.CapacityMonitor;
import org.axonframework.micrometer.EventProcessorLatencyMonitor;
import org.axonframework.micrometer.MessageCountingMonitor;
import org.axonframework.micrometer.MessageTimerMonitor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMetricRegistry {
    private static final Logger logger = LoggerFactory.getLogger(GlobalMetricRegistry.class);
    private final MeterRegistry registry;

    public GlobalMetricRegistry() {
        this((MeterRegistry)new SimpleMeterRegistry());
    }

    public GlobalMetricRegistry(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }

    public Configurer registerWithConfigurer(Configurer configurer) {
        return configurer.configureMessageMonitor(configuration -> (componentType, componentName) -> this.registerComponent((Class<?>)componentType, (String)componentName));
    }

    public MessageMonitor<? extends Message<?>> registerComponent(Class<?> componentType, String componentName) {
        if (EventProcessor.class.isAssignableFrom(componentType)) {
            return this.registerEventProcessor(componentName);
        }
        if (CommandBus.class.isAssignableFrom(componentType)) {
            return this.registerCommandBus(componentName);
        }
        if (EventBus.class.isAssignableFrom(componentType)) {
            return this.registerEventBus(componentName);
        }
        if (QueryBus.class.isAssignableFrom(componentType)) {
            return this.registerQueryBus(componentName);
        }
        logger.warn("Cannot provide MessageMonitor for component [{}] of type [{}]. Returning No-Op instance.", (Object)componentName, (Object)componentType.getSimpleName());
        return NoOpMessageMonitor.instance();
    }

    public MessageMonitor<? super EventMessage<?>> registerEventProcessor(String name) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.buildMonitor(name, this.registry);
        EventProcessorLatencyMonitor eventProcessorLatencyMonitor = EventProcessorLatencyMonitor.buildMonitor(name, this.registry);
        CapacityMonitor capacityMonitor = CapacityMonitor.buildMonitor(name, this.registry);
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(name, this.registry);
        ArrayList<Object> monitors = new ArrayList<Object>();
        monitors.add(messageTimerMonitor);
        monitors.add(eventProcessorLatencyMonitor);
        monitors.add(capacityMonitor);
        monitors.add(messageCountingMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<? super EventMessage<?>> registerEventBus(String name) {
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(name, this.registry);
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.buildMonitor(name, this.registry);
        return new MultiMessageMonitor(Arrays.asList(messageCountingMonitor, messageTimerMonitor));
    }

    public MessageMonitor<? super CommandMessage<?>> registerCommandBus(String name) {
        return this.registerDefaultHandlerMessageMonitor(name);
    }

    public MessageMonitor<? super QueryMessage<?, ?>> registerQueryBus(String name) {
        return this.registerDefaultHandlerMessageMonitor(name);
    }

    private MessageMonitor<Message<?>> registerDefaultHandlerMessageMonitor(String name) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.buildMonitor(name, this.registry);
        CapacityMonitor capacityMonitor = CapacityMonitor.buildMonitor(name, this.registry);
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(name, this.registry);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }
}

