/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import org.axonframework.messaging.Message;
import org.axonframework.micrometer.reservoir.SlidingTimeWindowReservoir;
import org.axonframework.monitoring.MessageMonitor;

public class CapacityMonitor
implements MessageMonitor<Message<?>> {
    private final SlidingTimeWindowReservoir timeWindowedDurationMeasurements;
    private final TimeUnit timeUnit;
    private final Clock clock;
    private final long window;

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, 10L, TimeUnit.MINUTES);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, window, timeUnit, Clock.SYSTEM);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit, Clock clock) {
        CapacityMonitor capacityMonitor = new CapacityMonitor(window, timeUnit, clock);
        meterRegistry.gauge(meterNamePrefix + ".capacity", (Object)capacityMonitor, CapacityMonitor::calculateCapacity);
        return capacityMonitor;
    }

    private CapacityMonitor(long window, TimeUnit timeUnit, Clock clock) {
        this.timeWindowedDurationMeasurements = new SlidingTimeWindowReservoir(window, timeUnit, clock);
        this.timeUnit = timeUnit;
        this.clock = clock;
        this.window = window;
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        final long start = this.clock.monotonicTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                CapacityMonitor.this.timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }

            public void reportFailure(Throwable cause) {
                CapacityMonitor.this.timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }

            public void reportIgnored() {
                CapacityMonitor.this.timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }
        };
    }

    private double calculateCapacity() {
        long totalProcessTime = this.timeWindowedDurationMeasurements.getMeasurements().stream().reduce(0L, Long::sum);
        return (double)totalProcessTime / (double)this.timeUnit.toNanos(this.window);
    }
}

