/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>>,
MetricSet {
    private final Clock clock;
    private final AtomicLong processTime = new AtomicLong();

    public EventProcessorLatencyMonitor() {
        this(Clock.systemUTC());
    }

    public EventProcessorLatencyMonitor(Clock clock) {
        this.clock = clock;
    }

    public MessageMonitor.MonitorCallback onMessageIngested(EventMessage<?> message) {
        if (message != null) {
            this.processTime.set(Duration.between(message.getTimestamp(), this.clock.instant()).toMillis());
        }
        return NoOpMessageMonitorCallback.INSTANCE;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("latency", (Metric)((Gauge)this.processTime::get));
        return metrics;
    }
}

