/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>>,
MetricSet {
    private final AtomicLong lastReceivedTime = new AtomicLong(-1L);
    private final AtomicLong lastProcessedTime = new AtomicLong(-1L);
    private final AtomicLong processTime = new AtomicLong(0L);

    public MessageMonitor.MonitorCallback onMessageIngested(final EventMessage<?> message) {
        if (message == null) {
            return NoOpMessageMonitorCallback.INSTANCE;
        }
        this.updateIfMaxValue(this.lastReceivedTime, message.getTimestamp().toEpochMilli());
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                this.update();
            }

            public void reportFailure(Throwable cause) {
                this.update();
            }

            public void reportIgnored() {
                this.update();
            }

            private void update() {
                EventProcessorLatencyMonitor.this.updateIfMaxValue(EventProcessorLatencyMonitor.this.lastProcessedTime, message.getTimestamp().toEpochMilli());
            }
        };
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("latency", (Metric)((Gauge)this.processTime::get));
        return metrics;
    }

    private void updateIfMaxValue(AtomicLong atomicLong, long timestamp) {
        atomicLong.accumulateAndGet(timestamp, (currentValue, newValue) -> Math.max(newValue, currentValue));
        long lastProcessed = this.lastProcessedTime.longValue();
        long lastReceived = this.lastReceivedTime.longValue();
        if (lastReceived == -1L || lastProcessed == -1L) {
            this.processTime.set(0L);
        } else {
            this.processTime.set(lastReceived - lastProcessed);
        }
    }
}

