/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageCountingMonitor
implements MessageMonitor<Message<?>>,
MetricSet {
    private final Counter ingestedCounter = new Counter();
    private final Counter successCounter = new Counter();
    private final Counter failureCounter = new Counter();
    private final Counter processedCounter = new Counter();
    private final Counter ignoredCounter = new Counter();

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        this.ingestedCounter.inc();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                MessageCountingMonitor.this.processedCounter.inc();
                MessageCountingMonitor.this.successCounter.inc();
            }

            public void reportFailure(Throwable cause) {
                MessageCountingMonitor.this.processedCounter.inc();
                MessageCountingMonitor.this.failureCounter.inc();
            }

            public void reportIgnored() {
                MessageCountingMonitor.this.ignoredCounter.inc();
            }
        };
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metricSet = new HashMap<String, Metric>();
        metricSet.put("ingestedCounter", (Metric)this.ingestedCounter);
        metricSet.put("processedCounter", (Metric)this.processedCounter);
        metricSet.put("successCounter", (Metric)this.successCounter);
        metricSet.put("failureCounter", (Metric)this.failureCounter);
        metricSet.put("ignoredCounter", (Metric)this.ignoredCounter);
        return metricSet;
    }
}

