/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.metrics.CapacityMonitor;
import org.axonframework.metrics.EventProcessorLatencyMonitor;
import org.axonframework.metrics.MessageCountingMonitor;
import org.axonframework.metrics.MessageTimerMonitor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;

public class MessageMonitorFactory {
    public static MessageMonitor<EventMessage<?>> createEventProcessorMonitor(String eventProcessorName, MetricRegistry globalRegistry) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        EventProcessorLatencyMonitor eventProcessorLatencyMonitor = new EventProcessorLatencyMonitor();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        eventProcessingRegistry.register("latency", (Metric)eventProcessorLatencyMonitor);
        eventProcessingRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        globalRegistry.register(eventProcessorName, (Metric)eventProcessingRegistry);
        ArrayList<Object> monitors = new ArrayList<Object>();
        monitors.add(messageTimerMonitor);
        monitors.add(eventProcessorLatencyMonitor);
        monitors.add(capacityMonitor);
        monitors.add(messageCountingMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public static MessageMonitor<EventMessage<?>> createEventBusMonitor(MetricRegistry globalRegistry) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        globalRegistry.register("eventBus", (Metric)eventProcessingRegistry);
        ArrayList<MessageTimerMonitor> monitors = new ArrayList<MessageTimerMonitor>();
        monitors.add(messageTimerMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public static MessageMonitor<CommandMessage<?>> createCommandBusMonitor(MetricRegistry globalRegistry) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry commandHandlingRegistry = new MetricRegistry();
        commandHandlingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        commandHandlingRegistry.register("capacity", (Metric)capacityMonitor);
        commandHandlingRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        globalRegistry.register("commandHandling", (Metric)commandHandlingRegistry);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    private MessageMonitorFactory() {
    }
}

