/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.core.Message;

public interface MessageMonitor<T extends Message> {
    public MonitorCallback onMessageIngested(@Nonnull T var1);

    default public Map<? super T, MonitorCallback> onMessagesIngested(@Nonnull Collection<? extends T> messages) {
        return messages.stream().collect(Collectors.toMap(msg -> msg, this::onMessageIngested));
    }

    public static interface MonitorCallback {
        public void reportSuccess();

        public void reportFailure(Throwable var1);

        public void reportIgnored();

        default public BiConsumer<? super CommandResultMessage, ? super Throwable> complete() {
            return (r, e) -> {
                if (e == null) {
                    this.reportSuccess();
                } else {
                    this.reportFailure((Throwable)e);
                }
            };
        }
    }
}

