/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.tracing;

import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.tracing.EventBusSpanFactory;
import org.axonframework.messaging.tracing.Span;
import org.axonframework.messaging.tracing.SpanFactory;

public class DefaultEventBusSpanFactory
implements EventBusSpanFactory {
    private final SpanFactory spanFactory;

    protected DefaultEventBusSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
    }

    @Override
    public Span createPublishEventSpan(EventMessage eventMessage) {
        return this.spanFactory.createDispatchSpan(() -> "EventBus.publishEvent", eventMessage, new Message[0]);
    }

    @Override
    public Span createCommitEventsSpan() {
        return this.spanFactory.createInternalSpan(() -> "EventBus.commitEvents");
    }

    @Override
    public EventMessage propagateContext(EventMessage eventMessage) {
        return this.spanFactory.propagateContext(eventMessage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.builderSpanFactory, (String)"spanFactory may not be null");
        }

        public DefaultEventBusSpanFactory build() {
            return new DefaultEventBusSpanFactory(this);
        }
    }
}

