/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token.store.jpa;

import jakarta.annotation.Nonnull;
import jakarta.persistence.LockModeType;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.axonframework.common.BuilderUtils;

public record JpaTokenStoreConfiguration(@Nonnull LockModeType loadingLockMode, @Nonnull TemporalAmount claimTimeout, @Nonnull String nodeId) {
    public static JpaTokenStoreConfiguration DEFAULT = new JpaTokenStoreConfiguration(LockModeType.PESSIMISTIC_WRITE, Duration.ofSeconds(10L), ManagementFactory.getRuntimeMXBean().getName());

    public JpaTokenStoreConfiguration {
        BuilderUtils.assertNonEmpty((String)nodeId, (String)"The nodeId may not be empty.");
    }

    public JpaTokenStoreConfiguration loadingLockMode(LockModeType loadingLockMode) {
        BuilderUtils.assertNonNull((Object)loadingLockMode, (String)"The loading lock mode may not be null.");
        return new JpaTokenStoreConfiguration(loadingLockMode, this.claimTimeout, this.nodeId);
    }

    public JpaTokenStoreConfiguration claimTimeout(TemporalAmount claimTimeout) {
        BuilderUtils.assertNonNull((Object)claimTimeout, (String)"The claim timeout may not be null.");
        return new JpaTokenStoreConfiguration(this.loadingLockMode, claimTimeout, this.nodeId);
    }

    public JpaTokenStoreConfiguration nodeId(String nodeId) {
        BuilderUtils.assertNonEmpty((String)nodeId, (String)"The nodeId may not be null or empty.");
        return new JpaTokenStoreConfiguration(this.loadingLockMode, this.claimTimeout, nodeId);
    }
}

