/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.interception;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventHandler;
import org.axonframework.messaging.eventhandling.EventMessage;

@Internal
public class EventMessageHandlerInterceptorChain
implements MessageHandlerInterceptorChain<EventMessage> {
    private final EventHandler interceptingHandler;

    public EventMessageHandlerInterceptorChain(@Nonnull List<MessageHandlerInterceptor<? super EventMessage>> interceptors, @Nonnull EventHandler eventHandler) {
        Iterator<MessageHandlerInterceptor<? super EventMessage>> interceptorIterator = new LinkedList<MessageHandlerInterceptor<? super EventMessage>>(interceptors).descendingIterator();
        EventHandler interceptingHandler = Objects.requireNonNull(eventHandler, "The Event Handler may not be null.");
        while (interceptorIterator.hasNext()) {
            interceptingHandler = new InterceptingHandler(interceptorIterator.next(), interceptingHandler);
        }
        this.interceptingHandler = interceptingHandler;
    }

    @Override
    @Nonnull
    public MessageStream<?> proceed(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        try {
            return this.interceptingHandler.handle(event, context);
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    private record InterceptingHandler(MessageHandlerInterceptor<? super EventMessage> interceptor, EventHandler next) implements EventHandler,
    MessageHandlerInterceptorChain<EventMessage>
    {
        @Override
        @Nonnull
        public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
            return this.interceptor.interceptOnHandle(event, context, this).ignoreEntries();
        }

        @Override
        @Nonnull
        public MessageStream<?> proceed(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
            return this.next.handle(event, context);
        }
    }
}

