/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.interception;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageDispatchInterceptorChain;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor<M extends Message>
implements MessageDispatchInterceptor<M>,
MessageHandlerInterceptor<M> {
    private final Logger logger;

    public LoggingInterceptor(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public LoggingInterceptor() {
        this.logger = LoggerFactory.getLogger(LoggingInterceptor.class);
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull M message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<M> interceptorChain) {
        this.logger.info("Dispatched message: [{}]", (Object)message.type().name());
        return interceptorChain.proceed(message, context);
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<M> interceptorChain) {
        this.logger.info("Incoming message: [{}]", (Object)message.type().name());
        return interceptorChain.proceed(message, context).map(returnValue -> {
            this.logger.info("[{}] executed successfully with a [{}] return value", (Object)message.type().name(), (Object)returnValue.message().payloadType().getSimpleName());
            return returnValue;
        }).onErrorContinue(e -> {
            this.logger.warn("[{}] resulted in an error", (Object)message.type().name(), e);
            return MessageStream.failed(e);
        });
    }
}

