/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.correlation;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.messaging.core.correlation.CorrelationDataProvider;
import org.axonframework.messaging.core.correlation.CorrelationDataProviderRegistry;

@Internal
public class DefaultCorrelationDataProviderRegistry
implements CorrelationDataProviderRegistry {
    private final List<ComponentDefinition<CorrelationDataProvider>> providerDefinitions = new ArrayList<ComponentDefinition<CorrelationDataProvider>>();

    @Override
    @Nonnull
    public CorrelationDataProviderRegistry registerProvider(@Nonnull ComponentBuilder<CorrelationDataProvider> providerBuilder) {
        this.providerDefinitions.add((ComponentDefinition<CorrelationDataProvider>)ComponentDefinition.ofType(CorrelationDataProvider.class).withBuilder(providerBuilder));
        return this;
    }

    @Override
    @Nonnull
    public List<CorrelationDataProvider> correlationDataProviders(@Nonnull Configuration config) {
        ArrayList<CorrelationDataProvider> correlationDataProviders = new ArrayList<CorrelationDataProvider>();
        for (ComponentDefinition<CorrelationDataProvider> providerDefinition : this.providerDefinitions) {
            if (!(providerDefinition instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(providerDefinition));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)providerDefinition;
            CorrelationDataProvider correlationDataProvider = (CorrelationDataProvider)creator.createComponent().resolve(config);
            correlationDataProviders.add(correlationDataProvider);
        }
        return correlationDataProviders;
    }
}

