/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.configuration;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.conversion.Converter;
import org.axonframework.conversion.json.JacksonConverter;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandPriorityCalculator;
import org.axonframework.messaging.commandhandling.RoutingStrategy;
import org.axonframework.messaging.commandhandling.SimpleCommandBus;
import org.axonframework.messaging.commandhandling.annotation.AnnotationRoutingStrategy;
import org.axonframework.messaging.commandhandling.gateway.CommandGateway;
import org.axonframework.messaging.commandhandling.gateway.ConvertingCommandGateway;
import org.axonframework.messaging.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.messaging.commandhandling.interception.InterceptingCommandBus;
import org.axonframework.messaging.core.ConfigurationApplicationContext;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.annotation.AnnotationMessageTypeResolver;
import org.axonframework.messaging.core.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.messaging.core.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.correlation.CorrelationDataProvider;
import org.axonframework.messaging.core.correlation.CorrelationDataProviderRegistry;
import org.axonframework.messaging.core.correlation.DefaultCorrelationDataProviderRegistry;
import org.axonframework.messaging.core.correlation.MessageOriginProvider;
import org.axonframework.messaging.core.interception.CorrelationDataInterceptor;
import org.axonframework.messaging.core.interception.DefaultDispatchInterceptorRegistry;
import org.axonframework.messaging.core.interception.DefaultHandlerInterceptorRegistry;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.core.interception.HandlerInterceptorRegistry;
import org.axonframework.messaging.core.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.core.unitofwork.TransactionalUnitOfWorkFactory;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.core.unitofwork.transaction.NoTransactionManager;
import org.axonframework.messaging.core.unitofwork.transaction.TransactionManager;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.EventSink;
import org.axonframework.messaging.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.messaging.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.monitoring.NoOpMessageMonitor;
import org.axonframework.messaging.monitoring.configuration.DefaultMessageMonitorRegistry;
import org.axonframework.messaging.monitoring.configuration.MessageMonitorRegistry;
import org.axonframework.messaging.monitoring.interception.MonitoringCommandHandlerInterceptor;
import org.axonframework.messaging.monitoring.interception.MonitoringEventDispatchInterceptor;
import org.axonframework.messaging.monitoring.interception.MonitoringEventHandlerInterceptor;
import org.axonframework.messaging.monitoring.interception.MonitoringQueryHandlerInterceptor;
import org.axonframework.messaging.monitoring.interception.MonitoringSubscriptionQueryUpdateDispatchInterceptor;
import org.axonframework.messaging.queryhandling.QueryBus;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryPriorityCalculator;
import org.axonframework.messaging.queryhandling.QueryUpdateEmitterParameterResolverFactory;
import org.axonframework.messaging.queryhandling.SimpleQueryBus;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.messaging.queryhandling.gateway.DefaultQueryGateway;
import org.axonframework.messaging.queryhandling.gateway.QueryGateway;
import org.axonframework.messaging.queryhandling.interception.InterceptingQueryBus;

public class MessagingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;
    public static final int CONVERTING_COMMAND_GATEWAY_ORDER = -2147483548;

    public int order() {
        return Integer.MAX_VALUE;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        MessagingConfigurationDefaults.registerComponents(registry);
        MessagingConfigurationDefaults.registerDecorators(registry);
    }

    private static void registerComponents(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(MessageTypeResolver.class, MessagingConfigurationDefaults::defaultMessageTypeResolver).registerIfNotPresent(Converter.class, c -> new JacksonConverter()).registerIfNotPresent(MessageConverter.class, MessagingConfigurationDefaults::defaultMessageConverter).registerIfNotPresent(EventConverter.class, MessagingConfigurationDefaults::defaultEventConverter).registerIfNotPresent(UnitOfWorkFactory.class, MessagingConfigurationDefaults::defaultUnitOfWorkFactory).registerIfNotPresent(CorrelationDataProviderRegistry.class, MessagingConfigurationDefaults::defaultCorrelationDataProviderRegistry).registerIfNotPresent(DispatchInterceptorRegistry.class, MessagingConfigurationDefaults::defaultDispatchInterceptorRegistry).registerIfNotPresent(HandlerInterceptorRegistry.class, MessagingConfigurationDefaults::defaultHandlerInterceptorRegistry).registerIfNotPresent(CommandBus.class, MessagingConfigurationDefaults::defaultCommandBus).registerIfNotPresent(CommandPriorityCalculator.class, c -> CommandPriorityCalculator.defaultCalculator()).registerIfNotPresent(RoutingStrategy.class, MessagingConfigurationDefaults::defaultRoutingStrategy).registerIfNotPresent(CommandGateway.class, MessagingConfigurationDefaults::defaultCommandGateway).registerIfNotPresent(EventGateway.class, MessagingConfigurationDefaults::defaultEventGateway).registerIfNotPresent(QueryBus.class, MessagingConfigurationDefaults::defaultQueryBus).registerIfNotPresent(QueryPriorityCalculator.class, c -> QueryPriorityCalculator.defaultCalculator()).registerIfNotPresent(QueryGateway.class, MessagingConfigurationDefaults::defaultQueryGateway).registerIfNotPresent(MessageMonitorRegistry.class, MessagingConfigurationDefaults::defaultMessageMonitorRegistry);
        ParameterResolverFactoryUtils.registerToComponentRegistry(registry, config -> new QueryUpdateEmitterParameterResolverFactory());
    }

    private static MessageTypeResolver defaultMessageTypeResolver(Configuration config) {
        return new AnnotationMessageTypeResolver();
    }

    private static DelegatingMessageConverter defaultMessageConverter(Configuration c) {
        return new DelegatingMessageConverter((Converter)c.getComponent(Converter.class));
    }

    private static DelegatingEventConverter defaultEventConverter(Configuration c) {
        return c.getOptionalComponent(MessageConverter.class).map(DelegatingEventConverter::new).orElse(new DelegatingEventConverter((Converter)c.getComponent(Converter.class)));
    }

    private static UnitOfWorkFactory defaultUnitOfWorkFactory(Configuration config) {
        return new TransactionalUnitOfWorkFactory((TransactionManager)config.getComponent(TransactionManager.class, NoTransactionManager::instance), new SimpleUnitOfWorkFactory(new ConfigurationApplicationContext(config)));
    }

    private static CorrelationDataProviderRegistry defaultCorrelationDataProviderRegistry(Configuration config) {
        return new DefaultCorrelationDataProviderRegistry().registerProvider((ComponentBuilder<CorrelationDataProvider>)((ComponentBuilder)c -> new MessageOriginProvider()));
    }

    private static DispatchInterceptorRegistry defaultDispatchInterceptorRegistry(Configuration config) {
        DispatchInterceptorRegistry dispatchInterceptorRegistry = new DefaultDispatchInterceptorRegistry();
        dispatchInterceptorRegistry = MessagingConfigurationDefaults.registerMonitoringDispatchInterceptors(dispatchInterceptorRegistry, config);
        List<CorrelationDataProvider> providers = ((CorrelationDataProviderRegistry)config.getComponent(CorrelationDataProviderRegistry.class)).correlationDataProviders(config);
        if (!providers.isEmpty()) {
            dispatchInterceptorRegistry = dispatchInterceptorRegistry.registerInterceptor((ComponentBuilder<MessageDispatchInterceptor<Message>>)((ComponentBuilder)c -> new CorrelationDataInterceptor(providers)));
        }
        return dispatchInterceptorRegistry;
    }

    private static HandlerInterceptorRegistry defaultHandlerInterceptorRegistry(Configuration config) {
        HandlerInterceptorRegistry handlerInterceptorRegistry = new DefaultHandlerInterceptorRegistry();
        handlerInterceptorRegistry = MessagingConfigurationDefaults.registerMonitoringHandlerInterceptors(handlerInterceptorRegistry, config);
        List<CorrelationDataProvider> providers = ((CorrelationDataProviderRegistry)config.getComponent(CorrelationDataProviderRegistry.class)).correlationDataProviders(config);
        if (!providers.isEmpty()) {
            handlerInterceptorRegistry = handlerInterceptorRegistry.registerInterceptor((ComponentBuilder<MessageHandlerInterceptor<Message>>)((ComponentBuilder)c -> new CorrelationDataInterceptor(providers)));
        }
        return handlerInterceptorRegistry;
    }

    private static CommandBus defaultCommandBus(Configuration config) {
        return new SimpleCommandBus((UnitOfWorkFactory)config.getComponent(UnitOfWorkFactory.class), config.getOptionalComponent(TransactionManager.class).map(tm -> tm).map(List::of).orElse(Collections.emptyList()));
    }

    private static RoutingStrategy defaultRoutingStrategy(Configuration config) {
        return new AnnotationRoutingStrategy();
    }

    private static CommandGateway defaultCommandGateway(Configuration config) {
        return new DefaultCommandGateway((CommandBus)config.getComponent(CommandBus.class), (MessageTypeResolver)config.getComponent(MessageTypeResolver.class), (CommandPriorityCalculator)config.getComponent(CommandPriorityCalculator.class), (RoutingStrategy)config.getComponent(RoutingStrategy.class));
    }

    private static EventGateway defaultEventGateway(Configuration config) {
        return new DefaultEventGateway((EventSink)config.getComponent(EventSink.class), (MessageTypeResolver)config.getComponent(MessageTypeResolver.class));
    }

    private static QueryGateway defaultQueryGateway(Configuration config) {
        return new DefaultQueryGateway((QueryBus)config.getComponent(QueryBus.class), (MessageTypeResolver)config.getComponent(MessageTypeResolver.class), (QueryPriorityCalculator)config.getComponent(QueryPriorityCalculator.class), (MessageConverter)config.getComponent(MessageConverter.class));
    }

    private static QueryBus defaultQueryBus(Configuration config) {
        return new SimpleQueryBus((UnitOfWorkFactory)config.getComponent(UnitOfWorkFactory.class));
    }

    private static MessageMonitorRegistry defaultMessageMonitorRegistry(Configuration config) {
        return new DefaultMessageMonitorRegistry();
    }

    private static void registerDecorators(@Nonnull ComponentRegistry registry) {
        registry.registerDecorator(CommandGateway.class, -2147483548, (config, name, delegate) -> new ConvertingCommandGateway((CommandGateway)delegate, (MessageConverter)config.getComponent(MessageConverter.class)));
        registry.registerDecorator(CommandBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageHandlerInterceptor<? super CommandMessage>> handlerInterceptors = ((HandlerInterceptorRegistry)config.getComponent(HandlerInterceptorRegistry.class)).commandInterceptors(config);
            List<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).commandInterceptors(config);
            return handlerInterceptors.isEmpty() && dispatchInterceptors.isEmpty() ? delegate : new InterceptingCommandBus((CommandBus)delegate, handlerInterceptors, dispatchInterceptors);
        });
        registry.registerDecorator(QueryBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageHandlerInterceptor<? super QueryMessage>> handlerInterceptors = ((HandlerInterceptorRegistry)config.getComponent(HandlerInterceptorRegistry.class)).queryInterceptors(config);
            List<MessageDispatchInterceptor<? super QueryMessage>> dispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).queryInterceptors(config);
            List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> updateDispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).subscriptionQueryUpdateInterceptors(config);
            return handlerInterceptors.isEmpty() && dispatchInterceptors.isEmpty() && updateDispatchInterceptors.isEmpty() ? delegate : new InterceptingQueryBus((QueryBus)delegate, handlerInterceptors, dispatchInterceptors, updateDispatchInterceptors);
        });
    }

    private static DispatchInterceptorRegistry registerMonitoringDispatchInterceptors(@Nonnull DispatchInterceptorRegistry dispatchInterceptorRegistry, @Nonnull Configuration config) {
        MessageMonitorRegistry messageMonitorRegistry = (MessageMonitorRegistry)config.getComponent(MessageMonitorRegistry.class);
        UnaryOperator eventDispatcher = Optional.of(messageMonitorRegistry.eventMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringEventDispatchInterceptor::new).map(it -> r -> r.registerEventInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>>)((ComponentBuilder)c -> it))).orElse(UnaryOperator.identity());
        UnaryOperator subscriptionQueryUpdateDispatcher = Optional.of(messageMonitorRegistry.subscriptionQueryUpdateMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringSubscriptionQueryUpdateDispatchInterceptor::new).map(it -> r -> r.registerSubscriptionQueryUpdateInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>)((ComponentBuilder)c -> it))).orElse(UnaryOperator.identity());
        return (DispatchInterceptorRegistry)eventDispatcher.andThen(subscriptionQueryUpdateDispatcher).apply(dispatchInterceptorRegistry);
    }

    private static HandlerInterceptorRegistry registerMonitoringHandlerInterceptors(@Nonnull HandlerInterceptorRegistry handlerInterceptorRegistry, @Nonnull Configuration config) {
        MessageMonitorRegistry messageMonitorRegistry = (MessageMonitorRegistry)config.getComponent(MessageMonitorRegistry.class);
        UnaryOperator commandDispatcher = Optional.of(messageMonitorRegistry.commandMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringCommandHandlerInterceptor::new).map(it -> r -> r.registerCommandInterceptor((ComponentBuilder<MessageHandlerInterceptor<? super CommandMessage>>)((ComponentBuilder)c -> it))).orElse(UnaryOperator.identity());
        UnaryOperator eventDispatcher = Optional.of(messageMonitorRegistry.eventMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringEventHandlerInterceptor::new).map(it -> r -> r.registerEventInterceptor((ComponentBuilder<MessageHandlerInterceptor<? super EventMessage>>)((ComponentBuilder)c -> it))).orElse(UnaryOperator.identity());
        UnaryOperator queryDispatcher = Optional.of(messageMonitorRegistry.queryMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringQueryHandlerInterceptor::new).map(it -> r -> r.registerQueryInterceptor((ComponentBuilder<MessageHandlerInterceptor<? super QueryMessage>>)((ComponentBuilder)c -> it))).orElse(UnaryOperator.identity());
        return (HandlerInterceptorRegistry)commandDispatcher.andThen(eventDispatcher).andThen(queryDispatcher).apply(handlerInterceptorRegistry);
    }
}

