/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.tracing;

import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.tracing.CommandBusSpanFactory;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.tracing.Span;
import org.axonframework.messaging.tracing.SpanFactory;

public class DefaultCommandBusSpanFactory
implements CommandBusSpanFactory {
    private final SpanFactory spanFactory;
    private final boolean distributedInSameTrace;

    protected DefaultCommandBusSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.distributedInSameTrace = builder.distributedInSameTrace;
    }

    @Override
    public Span createDispatchCommandSpan(CommandMessage commandMessage, boolean distributed) {
        if (distributed) {
            return this.spanFactory.createDispatchSpan(() -> "CommandBus.dispatchDistributedCommand", commandMessage, new Message[0]);
        }
        return this.spanFactory.createInternalSpan(() -> "CommandBus.dispatchCommand", commandMessage);
    }

    @Override
    public Span createHandleCommandSpan(CommandMessage commandMessage, boolean distributed) {
        if (distributed) {
            if (this.distributedInSameTrace) {
                return this.spanFactory.createChildHandlerSpan(() -> "CommandBus.handleDistributedCommand", commandMessage, new Message[0]);
            }
            return this.spanFactory.createLinkedHandlerSpan(() -> "CommandBus.handleDistributedCommand", commandMessage, new Message[0]);
        }
        return this.spanFactory.createChildHandlerSpan(() -> "CommandBus.handleCommand", commandMessage, new Message[0]);
    }

    @Override
    public CommandMessage propagateContext(CommandMessage commandMessage) {
        return this.spanFactory.propagateContext(commandMessage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private boolean distributedInSameTrace = true;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder distributedInSameTrace(boolean distributedInSameTrace) {
            this.distributedInSameTrace = distributedInSameTrace;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.builderSpanFactory, (String)"spanFactory may not be null");
        }

        public DefaultCommandBusSpanFactory build() {
            return new DefaultCommandBusSpanFactory(this);
        }
    }
}

