/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.sequencing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;

public class ExtractionSequencingPolicy<T, K>
implements SequencingPolicy {
    private final Class<T> payloadClass;
    private final Function<T, K> identifierExtractor;

    public ExtractionSequencingPolicy(@Nonnull Class<T> payloadClass, @Nonnull Function<T, K> identifierExtractor) {
        this.payloadClass = Objects.requireNonNull(payloadClass, "Payload class may not be null.");
        this.identifierExtractor = Objects.requireNonNull(identifierExtractor, "Identifier extractor function may not be null.");
    }

    @Override
    public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(eventMessage, "EventMessage may not be null");
        Objects.requireNonNull(context, "ProcessingContext may not be null");
        EventConverter eventConverter = context.component(EventConverter.class);
        T convertedPayload = eventMessage.payloadAs(this.payloadClass, (Converter)eventConverter);
        return Optional.ofNullable(this.identifierExtractor.apply(convertedPayload));
    }
}

