/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token.store.jpa;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Lob;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.axonframework.common.ClassUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.Segment;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;

@Entity
@IdClass(value=PK.class)
public class TokenEntry {
    public static Clock clock = Clock.systemUTC();
    @Lob
    @Column(length=10000)
    private byte[] token;
    @Basic
    private String tokenType;
    @Basic(optional=false)
    private String timestamp;
    @Basic
    private String owner;
    @Id
    private String processorName;
    @Id
    private int segment;
    @Basic(optional=false)
    private int mask;

    public static String computeTokenTimestamp() {
        return DateTimeUtils.formatInstant((TemporalAccessor)clock.instant());
    }

    public TokenEntry(@Nonnull String processorName, @Nonnull Segment segment, @Nullable TrackingToken token, @Nonnull Converter converter) {
        this.timestamp = DateTimeUtils.formatInstant((TemporalAccessor)clock.instant());
        if (token != null) {
            this.token = (byte[])converter.convert((Object)token, byte[].class);
            this.tokenType = token.getClass().getName();
        }
        this.processorName = processorName;
        this.segment = segment.getSegmentId();
        this.mask = segment.getMask();
    }

    protected TokenEntry() {
    }

    public TrackingToken getToken(@Nonnull Converter converter) {
        return this.token == null || this.tokenType == null ? null : (TrackingToken)converter.convert((Object)this.token, ClassUtils.loadClass((String)this.tokenType));
    }

    public boolean claim(String owner, TemporalAmount claimTimeout) {
        if (!this.mayClaim(owner, claimTimeout)) {
            return false;
        }
        this.timestamp = DateTimeUtils.formatInstant((TemporalAccessor)clock.instant());
        this.owner = owner;
        return true;
    }

    public boolean mayClaim(String owner, TemporalAmount claimTimeout) {
        return this.owner == null || owner.equals(this.owner) || this.expired(claimTimeout);
    }

    private boolean expired(TemporalAmount claimTimeout) {
        return this.timestamp().plus(claimTimeout).isBefore(clock.instant());
    }

    public boolean releaseClaim(String owner) {
        if (Objects.equals(this.owner, owner)) {
            this.owner = null;
            this.timestamp = DateTimeUtils.formatInstant((TemporalAccessor)clock.instant());
        }
        return this.owner == null;
    }

    public String timestampAsString() {
        return this.timestamp;
    }

    public Instant timestamp() {
        return DateTimeUtils.parseInstant((CharSequence)this.timestamp);
    }

    public void updateToken(@Nullable TrackingToken token, @Nonnull Converter converter) {
        this.timestamp = DateTimeUtils.formatInstant((TemporalAccessor)clock.instant());
        if (token != null) {
            this.token = (byte[])converter.convert((Object)token, byte[].class);
            this.tokenType = token.getClass().getName();
        } else {
            this.token = null;
            this.tokenType = null;
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public Segment getSegment() {
        return new Segment(this.segment, this.mask);
    }

    public static class PK {
        private String processorName;
        private int segment;

        public PK() {
        }

        public PK(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.segment == pk.segment && Objects.equals(this.processorName, pk.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

