/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.LongStream;
import org.axonframework.common.Assert;
import org.axonframework.common.CollectionUtils;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;

public class GapAwareTrackingToken
implements TrackingToken {
    private final long index;
    private final SortedSet<Long> gaps;
    private final transient long gapTruncationIndex;

    public static GapAwareTrackingToken newInstance(long index, Collection<Long> gaps) {
        return new GapAwareTrackingToken(index, gaps);
    }

    @JsonCreator
    @ConstructorProperties(value={"index", "gaps"})
    public GapAwareTrackingToken(@JsonProperty(value="index") long index, @JsonProperty(value="gaps") Collection<Long> gaps) {
        this(index, GapAwareTrackingToken.createSortedSetOf(gaps, index), 0L);
    }

    private GapAwareTrackingToken(long index, SortedSet<Long> gaps, long gapTruncationIndex) {
        this.index = index;
        this.gaps = gaps;
        this.gapTruncationIndex = gapTruncationIndex;
    }

    protected static SortedSet<Long> createSortedSetOf(Collection<Long> gaps, long index) {
        if (gaps == null || gaps.isEmpty()) {
            return Collections.emptySortedSet();
        }
        TreeSet<Long> gapSet = new TreeSet<Long>(gaps);
        Assert.isTrue(((Long)gapSet.last() < index ? 1 : 0) != 0, () -> String.format("Gap indices [%s] should all be smaller than head index [%d]", gaps, index));
        return gapSet;
    }

    public GapAwareTrackingToken advanceTo(long index, int maxGapOffset) {
        long newIndex;
        long smalledAllowedGap = Math.min(index, Math.max(this.gapTruncationIndex, Math.max(index, this.index) - (long)maxGapOffset));
        TreeSet<Long> gaps = new TreeSet<Long>(this.gaps.tailSet(smalledAllowedGap));
        if (gaps.remove(index) || this.gaps.contains(index)) {
            newIndex = this.index;
        } else if (index > this.index) {
            newIndex = index;
            LongStream.range(Math.max(this.index + 1L, smalledAllowedGap), index).forEach(gaps::add);
        } else {
            throw new IllegalArgumentException(String.format("The given index [%d] should be larger than the token index [%d] or be one of the token's gaps [%s]", index, this.index, gaps));
        }
        return new GapAwareTrackingToken(newIndex, gaps, smalledAllowedGap);
    }

    public GapAwareTrackingToken withGapsTruncatedAt(long truncationPoint) {
        if (this.gaps.isEmpty() || this.gaps.first() > truncationPoint) {
            return this;
        }
        TreeSet<Long> truncatedGaps = new TreeSet<Long>(this.gaps.tailSet(truncationPoint));
        return new GapAwareTrackingToken(this.index, truncatedGaps, truncationPoint);
    }

    public long getIndex() {
        return this.index;
    }

    public SortedSet<Long> getGaps() {
        return Collections.unmodifiableSortedSet(this.gaps);
    }

    @Override
    public GapAwareTrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof GapAwareTrackingToken), () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        TreeSet<Long> mergedGaps = new TreeSet<Long>(this.gaps);
        mergedGaps.addAll(otherToken.gaps);
        long mergedIndex = this.calculateIndex(otherToken, mergedGaps);
        mergedGaps.removeIf(i -> i >= mergedIndex);
        return new GapAwareTrackingToken(mergedIndex, mergedGaps, Math.min(this.gapTruncationIndex, otherToken.gapTruncationIndex));
    }

    @Override
    public TrackingToken upperBound(TrackingToken otherToken) {
        Assert.isTrue((boolean)(otherToken instanceof GapAwareTrackingToken), () -> "Incompatible token type provided.");
        GapAwareTrackingToken other = (GapAwareTrackingToken)otherToken;
        SortedSet newGaps = (SortedSet)CollectionUtils.intersect(this.gaps, other.gaps, TreeSet::new);
        long min = Math.min(this.index, other.index) + 1L;
        SortedSet mergedGaps = (SortedSet)CollectionUtils.merge(this.gaps.tailSet(min), other.gaps.tailSet(min), TreeSet::new);
        newGaps.addAll(mergedGaps);
        return new GapAwareTrackingToken(Math.max(this.index, other.index), newGaps, Math.min(this.gapTruncationIndex, other.gapTruncationIndex));
    }

    private long calculateIndex(GapAwareTrackingToken otherToken, SortedSet<Long> mergedGaps) {
        long mergedIndex = Math.min(this.index, otherToken.index);
        while (mergedGaps.contains(mergedIndex)) {
            --mergedIndex;
        }
        return mergedIndex;
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof GapAwareTrackingToken), () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        if (!this.gaps.isEmpty() && !this.gaps.headSet(otherToken.gapTruncationIndex).isEmpty() && this.gapTruncationIndex < otherToken.gapTruncationIndex) {
            return this.withGapsTruncatedAt(otherToken.gapTruncationIndex).covers(other);
        }
        return otherToken.index <= this.index && !this.gaps.contains(otherToken.index) && otherToken.gaps.containsAll(this.gaps.headSet(otherToken.index));
    }

    public boolean hasGaps() {
        return !this.gaps.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GapAwareTrackingToken that = (GapAwareTrackingToken)o;
        long truncationIndex = Math.max(this.gapTruncationIndex, that.gapTruncationIndex) + 1L;
        return this.index == that.index && Objects.equals(this.gaps.tailSet(truncationIndex), that.gaps.tailSet(truncationIndex));
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return "GapAwareTrackingToken{index=" + this.index + ", gaps=" + String.valueOf(this.gaps) + "}";
    }

    @Override
    public OptionalLong position() {
        return OptionalLong.of(this.index);
    }
}

