/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.LegacyResources;
import org.axonframework.messaging.core.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.annotation.SequenceNumber;

@Priority(value=0x3FFFFFFF)
public final class SequenceNumberParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<SequenceNumber, Long> {
    private final ParameterResolver<Long> resolver = new SequenceNumberParameterResolver();

    public SequenceNumberParameterResolverFactory() {
        super(SequenceNumber.class, Long.class);
    }

    @Override
    protected ParameterResolver<Long> getResolver() {
        return this.resolver;
    }

    public static class SequenceNumberParameterResolver
    implements ParameterResolver<Long> {
        @Override
        @Nonnull
        public CompletableFuture<Long> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(context.getResource(LegacyResources.AGGREGATE_SEQUENCE_NUMBER_KEY));
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(LegacyResources.AGGREGATE_SEQUENCE_NUMBER_KEY);
        }
    }
}

