/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventHandler;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.NoHandlerForEventException;
import org.axonframework.messaging.eventhandling.sequencing.HierarchicalSequencingPolicy;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;
import org.axonframework.messaging.eventhandling.sequencing.SequentialPerAggregatePolicy;
import org.axonframework.messaging.eventhandling.sequencing.SequentialPolicy;

public class SimpleEventHandlingComponent
implements EventHandlingComponent {
    private static final SequencingPolicy DEFAULT_SEQUENCING_POLICY = new HierarchicalSequencingPolicy(SequentialPerAggregatePolicy.instance(), SequentialPolicy.INSTANCE);
    private final ConcurrentHashMap<QualifiedName, List<EventHandler>> eventHandlers = new ConcurrentHashMap();
    private final SequencingPolicy sequencingPolicy;

    public SimpleEventHandlingComponent() {
        this.sequencingPolicy = DEFAULT_SEQUENCING_POLICY;
    }

    public SimpleEventHandlingComponent(@Nonnull SequencingPolicy sequencingPolicy) {
        this.sequencingPolicy = Objects.requireNonNull(sequencingPolicy, "Sequencing Policy may not be null.");
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        QualifiedName name = event.type().qualifiedName();
        List<EventHandler> handlers = this.eventHandlers.get(name);
        if (handlers == null || handlers.isEmpty()) {
            return MessageStream.failed(new NoHandlerForEventException(name, SimpleEventHandlingComponent.class.getName()));
        }
        MessageStream<Message> result = MessageStream.empty();
        for (EventHandler handler : handlers) {
            MessageStream.Empty<Message> handlerResult = handler.handle(event, context);
            result = result.concatWith(handlerResult);
        }
        return result.ignoreEntries().cast();
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler handler) {
        Objects.requireNonNull(handler, "The given handler cannot be null.");
        names.forEach(name -> this.eventHandlers.compute((QualifiedName)name, (q, handlers) -> {
            if (handlers == null) {
                handlers = new CopyOnWriteArrayList<EventHandler>();
            }
            handlers.add(handler);
            return handlers;
        }));
        return this;
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler handler) {
        return this.subscribe((Set)Set.of(name), handler);
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.eventHandlers.keySet());
    }

    @Override
    @Nonnull
    public Object sequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        QualifiedName qualifiedName = event.type().qualifiedName();
        List<EventHandler> handlers = this.eventHandlers.get(qualifiedName);
        if (handlers == null || handlers.isEmpty()) {
            return this.sequencingPolicy.getSequenceIdentifierFor(event, context).get();
        }
        return handlers.stream().filter(EventHandlingComponent.class::isInstance).map(EventHandlingComponent.class::cast).findFirst().map(component -> component.sequenceIdentifierFor(event, context)).orElse(this.sequencingPolicy.getSequenceIdentifierFor(event, context).get());
    }
}

