/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.unitofwork.transaction;

import jakarta.annotation.Nonnull;
import java.util.function.Supplier;
import org.axonframework.messaging.core.unitofwork.ProcessingLifecycle;
import org.axonframework.messaging.core.unitofwork.ProcessingLifecycleHandlerRegistrar;
import org.axonframework.messaging.core.unitofwork.transaction.Transaction;

public interface TransactionManager
extends ProcessingLifecycleHandlerRegistrar {
    public Transaction startTransaction();

    default public void executeInTransaction(Runnable task) {
        Transaction transaction = this.startTransaction();
        try {
            task.run();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }

    default public void attachToProcessingLifecycle(ProcessingLifecycle processingLifecycle) {
        processingLifecycle.runOnPreInvocation(pc -> {
            Transaction transaction = this.startTransaction();
            pc.runOnCommit(p -> transaction.commit());
            pc.onError((p, phase, e) -> transaction.rollback());
        });
    }

    @Override
    default public void registerHandlers(@Nonnull ProcessingLifecycle processingLifecycle) {
        processingLifecycle.runOnPreInvocation(pc -> {
            Transaction transaction = this.startTransaction();
            pc.runOnCommit(p -> transaction.commit());
            pc.onError((p, phase, e) -> transaction.rollback());
        });
    }

    default public <T> T fetchInTransaction(Supplier<T> supplier) {
        Transaction transaction = this.startTransaction();
        try {
            T result = supplier.get();
            transaction.commit();
            return result;
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }
}

