/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.conversion;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.conversion.MessageConverter;

public class DelegatingMessageConverter
implements MessageConverter {
    private final Converter delegate;

    public DelegatingMessageConverter(@Nonnull Converter delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The Converter must not be null.");
    }

    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        return this.delegate.canConvert(targetType, sourceType);
    }

    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        return (T)this.delegate.convert(input, targetType);
    }

    @Override
    @Nullable
    public <M extends Message, T> T convertPayload(@Nonnull M message, @Nonnull Type targetType) {
        return message.payloadAs(targetType, this.delegate);
    }

    @Override
    @Nonnull
    public <M extends Message> M convertMessage(@Nonnull M message, @Nonnull Type targetType) {
        return (M)message.withConvertedPayload(targetType, this.delegate);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
    }

    @Internal
    public Converter delegate() {
        return this.delegate;
    }
}

