/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.tracing;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.tracing.CommandBusSpanFactory;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.tracing.Span;

public class TracingCommandBus
implements CommandBus {
    private final CommandBus delegate;
    private final CommandBusSpanFactory spanFactory;

    public TracingCommandBus(@Nonnull CommandBus delegate, @Nonnull CommandBusSpanFactory spanFactory) {
        this.delegate = Objects.requireNonNull(delegate, "The command bus delegate must be null.");
        this.spanFactory = Objects.requireNonNull(spanFactory, "The CommandBusSpanFactory must not be null.");
    }

    @Override
    public TracingCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        this.delegate.subscribe(name, (CommandHandler)new TracingHandler(Objects.requireNonNull(commandHandler, "The command handler cannot be null.")));
        return this;
    }

    @Override
    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        Span span = this.spanFactory.createDispatchCommandSpan(Objects.requireNonNull(command, "The command message cannot be null."), false);
        return span.runSupplierAsync(() -> this.delegate.dispatch(this.spanFactory.propagateContext(command), processingContext));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
        descriptor.describeProperty("spanFactory", (Object)this.spanFactory);
    }

    private class TracingHandler
    implements CommandHandler {
        private final CommandHandler handler;

        public TracingHandler(CommandHandler handler) {
            this.handler = handler;
        }

        @Override
        @Nonnull
        public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage message, @Nonnull ProcessingContext processingContext) {
            return TracingCommandBus.this.spanFactory.createHandleCommandSpan(message, false).runSupplier(() -> this.handler.handle(message, processingContext));
        }
    }
}

