/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.reactivestreams.Publisher;
import reactor.util.concurrent.Queues;

public interface QueryGateway
extends DescribableComponent {
    @Nonnull
    public <R> CompletableFuture<R> query(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public <R> CompletableFuture<R> query(@Nonnull Object query, @Nonnull Class<R> responseType) {
        return this.query(query, responseType, null);
    }

    @Nonnull
    public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object query, @Nonnull Class<R> responseType) {
        return this.queryMany(query, responseType, null);
    }

    @Nonnull
    public <R> Publisher<R> streamingQuery(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public <R> Publisher<R> streamingQuery(@Nonnull Object query, @Nonnull Class<R> responseType) {
        return this.streamingQuery(query, responseType, null);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, responseType, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType) {
        return this.subscriptionQuery(query, responseType, m -> m.payloadAs(responseType), null, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.subscriptionQuery(query, responseType, m -> m.payloadAs(responseType), context, updateBufferSize);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nonnull Function<QueryResponseMessage, R> mapper, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, responseType, mapper, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nonnull Function<QueryResponseMessage, R> mapper) {
        return this.subscriptionQuery(query, responseType, mapper, null, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, int updateBufferSize) {
        return this.subscriptionQuery(query, responseType, m -> m.payloadAs(responseType), null, updateBufferSize);
    }

    @Nonnull
    public <R> Publisher<R> subscriptionQuery(@Nonnull Object var1, @Nonnull Class<R> var2, @Nonnull Function<QueryResponseMessage, R> var3, @Nullable ProcessingContext var4, int var5);

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nonnull Function<QueryResponseMessage, R> mapper, int updateBufferSize) {
        return this.subscriptionQuery(query, responseType, mapper, null, updateBufferSize);
    }
}

