/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.axonframework.messaging.ApplicationContext;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;

public class SimpleUnitOfWorkFactory
implements UnitOfWorkFactory {
    private final ApplicationContext applicationContext;
    private final UnaryOperator<UnitOfWorkConfiguration> factoryCustomization;

    public SimpleUnitOfWorkFactory(@Nonnull ApplicationContext applicationContext) {
        this(applicationContext, c -> c);
    }

    public SimpleUnitOfWorkFactory(@Nonnull ApplicationContext applicationContext, @Nonnull UnaryOperator<UnitOfWorkConfiguration> factoryCustomization) {
        Objects.requireNonNull(applicationContext, "The applicationContext may not be null.");
        Objects.requireNonNull(factoryCustomization, "The factoryCustomization may not be null.");
        this.applicationContext = applicationContext;
        this.factoryCustomization = factoryCustomization;
    }

    @Override
    @Nonnull
    public UnitOfWork create(@Nonnull String identifier, @Nonnull UnaryOperator<UnitOfWorkConfiguration> customization) {
        Objects.requireNonNull(identifier, "The identifier may not be null.");
        Objects.requireNonNull(customization, "The customization may not be null.");
        UnitOfWorkConfiguration configuration = (UnitOfWorkConfiguration)customization.apply((UnitOfWorkConfiguration)this.factoryCustomization.apply(UnitOfWorkConfiguration.defaultValues()));
        return new UnitOfWork(identifier, configuration.workScheduler(), this.applicationContext);
    }
}

