/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.serialization.Converter;

public class GenericResultMessage
extends MessageDecorator
implements ResultMessage {
    private final Throwable exception;

    public GenericResultMessage(@Nonnull MessageType type, @Nullable Object result) {
        this(type, result, (Map<String, String>)Metadata.emptyInstance());
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nonnull Throwable exception) {
        this(type, exception, (Map<String, String>)Metadata.emptyInstance());
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nullable Object result, @Nonnull Map<String, String> metadata) {
        this(new GenericMessage(type, result, metadata));
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nonnull Throwable exception, @Nonnull Map<String, String> metadata) {
        this(new GenericMessage(type, null, metadata), exception);
    }

    public GenericResultMessage(@Nonnull Message delegate) {
        this(delegate, GenericResultMessage.findExceptionResult(delegate));
    }

    public GenericResultMessage(@Nonnull Message delegate, @Nullable Throwable exception) {
        super(delegate);
        this.exception = exception;
    }

    @Deprecated
    public static ResultMessage asResultMessage(Object result) {
        if (result instanceof ResultMessage) {
            ResultMessage r = (ResultMessage)result;
            return r;
        }
        if (result instanceof Message) {
            Message resultMessage = (Message)result;
            return new GenericResultMessage(resultMessage);
        }
        MessageType type = result == null ? new MessageType("empty.result") : new MessageType(result.getClass());
        return new GenericResultMessage(type, result);
    }

    @Deprecated
    public static ResultMessage asResultMessage(Throwable exception) {
        return new GenericResultMessage(new MessageType(exception.getClass()), exception);
    }

    private static Throwable findExceptionResult(Message delegate) {
        if (delegate instanceof ResultMessage && ((ResultMessage)delegate).isExceptional()) {
            return ((ResultMessage)delegate).exceptionResult();
        }
        return null;
    }

    @Override
    public boolean isExceptional() {
        return this.exception != null;
    }

    @Override
    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    @Override
    @Nonnull
    public ResultMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericResultMessage(this.delegate().withMetadata(metadata), this.exception);
    }

    @Override
    @Nonnull
    public ResultMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericResultMessage(this.delegate().andMetadata(metadata), this.exception);
    }

    @Override
    @Nonnull
    public ResultMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return this.optionalExceptionResult().isPresent() ? new GenericResultMessage(converted, this.optionalExceptionResult().get()) : new GenericResultMessage(converted);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        stringBuilder.append("payload={").append(this.isExceptional() ? null : this.payload()).append('}').append(", metadata={").append(this.metadata()).append('}').append(", messageIdentifier='").append(this.identifier()).append('\'').append(", exception='").append(this.exception).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericResultMessage";
    }

    @Override
    public Object payload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return super.payload();
    }
}

