/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class ConcatenatingMessageStream<M extends Message>
implements MessageStream<M> {
    private final MessageStream<M> first;
    private final MessageStream<M> second;

    ConcatenatingMessageStream(@Nonnull MessageStream<M> first, @Nonnull MessageStream<M> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        if (this.first.isCompleted() && this.first.error().isEmpty()) {
            return this.second.next();
        }
        return this.first.next();
    }

    @Override
    public void setCallback(@Nonnull Runnable callback) {
        this.first.setCallback(() -> {
            if (!this.first.isCompleted() || !this.first.error().isEmpty() || this.second.hasNextAvailable() || this.second.isCompleted()) {
                if (this.first.error().isPresent()) {
                    this.second.close();
                }
                callback.run();
            }
        });
        this.second.setCallback(() -> {
            if (this.first.isCompleted() && this.first.error().isEmpty()) {
                callback.run();
            }
        });
    }

    @Override
    public Optional<Throwable> error() {
        return this.first.isCompleted() ? this.first.error().or(this.second::error) : this.first.error();
    }

    @Override
    public boolean isCompleted() {
        return this.first.isCompleted() && (this.second.isCompleted() || this.first.error().isPresent());
    }

    @Override
    public boolean hasNextAvailable() {
        return this.first.isCompleted() && this.first.error().isEmpty() ? this.second.hasNextAvailable() : this.first.hasNextAvailable();
    }

    @Override
    public void close() {
        this.first.close();
        this.second.close();
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<M>, R> accumulator) {
        return this.first.reduce(identity, accumulator).thenCompose(intermediate -> this.second.reduce(intermediate, accumulator));
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        if (this.first.isCompleted() && this.first.error().isEmpty()) {
            return this.second.peek();
        }
        return this.first.peek();
    }
}

