/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.token.ReplayToken;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.replay.annotations.ReplayContext;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayContextParameterResolverFactory
implements ParameterResolverFactory {
    @Nullable
    public ParameterResolver<Object> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (parameter.isAnnotationPresent(ReplayContext.class)) {
            return new ReplayContextParameterResolver(parameter.getType());
        }
        return null;
    }

    private static class ReplayContextParameterResolver
    implements ParameterResolver<Object> {
        private final Class<?> type;

        public ReplayContextParameterResolver(Class<?> type) {
            this.type = type;
        }

        @Override
        @Nullable
        public Object resolveParameterValue(@Nonnull ProcessingContext context) {
            Optional<TrackingToken> token = TrackingToken.fromContext(context);
            if (token.isPresent()) {
                return ReplayToken.replayContext(token.get(), this.type).orElse(null);
            }
            return false;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

