/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.eventhandling.processors.streaming.token.ReplayToken;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.replay.annotations.AllowReplay;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayAwareMessageHandlerWrapper
implements HandlerEnhancerDefinition {
    private static final Map<String, Object> DEFAULT_SETTING = Collections.singletonMap("allowReplay", Boolean.TRUE);

    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        boolean isReplayAllowed = (Boolean)original.attribute("AllowReplay.allowReplay").orElseGet(() -> original.unwrap(Member.class).map(Member::getDeclaringClass).map(c -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)c, AllowReplay.class).orElse(DEFAULT_SETTING)).orElse(DEFAULT_SETTING).get("allowReplay"));
        if (!isReplayAllowed) {
            return new ReplayBlockingMessageHandlingMember<T>(original);
        }
        return original;
    }

    private static class ReplayBlockingMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T> {
        public static final Optional<Boolean> NO_REPLAY = Optional.of(Boolean.FALSE);

        public ReplayBlockingMessageHandlingMember(MessageHandlingMember<T> original) {
            super(original);
        }

        @Override
        public Object handleSync(@Nonnull Message message, @Nonnull ProcessingContext context, @Nullable T target) throws Exception {
            Optional<TrackingToken> optionalToken = TrackingToken.fromContext(context);
            if (optionalToken.isPresent() && ReplayToken.isReplay(optionalToken.get())) {
                return null;
            }
            return super.handleSync(message, context, target);
        }

        @Override
        public <R> Optional<R> attribute(String attributeKey) {
            if ("AllowReplay.allowReplay".equals(attributeKey)) {
                return NO_REPLAY;
            }
            return super.attribute(attributeKey);
        }
    }
}

