/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import org.axonframework.common.Priority;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.annotations.Timestamp;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class TimestampParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<Timestamp, Instant> {
    private final ParameterResolver<Instant> resolver = new TimestampParameterResolver();

    public TimestampParameterResolverFactory() {
        super(Timestamp.class, Instant.class);
    }

    @Override
    protected ParameterResolver<Instant> getResolver() {
        return this.resolver;
    }

    static class TimestampParameterResolver
    implements ParameterResolver<Instant> {
        TimestampParameterResolver() {
        }

        @Override
        @Nullable
        public Instant resolveParameterValue(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message instanceof EventMessage) {
                EventMessage eventMessage = (EventMessage)message;
                return eventMessage.timestamp();
            }
            return null;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

