/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.monitoring;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.StreamingQueryMessage;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

public class MonitoringQueryBus {

    private static class MonitorCallbackContextWriter
    implements UnaryOperator<Context> {
        private final MessageMonitor<? super QueryMessage> messageMonitor;
        private final StreamingQueryMessage query;

        private MonitorCallbackContextWriter(MessageMonitor<? super QueryMessage> messageMonitor, StreamingQueryMessage query) {
            this.messageMonitor = messageMonitor;
            this.query = query;
        }

        @Override
        public Context apply(Context ctx) {
            return ctx.put(MessageMonitor.MonitorCallback.class, (Object)this.messageMonitor.onMessageIngested(this.query));
        }
    }

    private static class SuccessReporter
    implements Consumer<Signal<?>> {
        private SuccessReporter() {
        }

        @Override
        public void accept(Signal signal) {
            MessageMonitor.MonitorCallback m = (MessageMonitor.MonitorCallback)signal.getContextView().get(MessageMonitor.MonitorCallback.class);
            if (signal.isOnNext()) {
                m.reportSuccess();
            } else if (signal.isOnError()) {
                m.reportFailure(signal.getThrowable());
            }
        }
    }
}

