/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.serialization.Converter;

public class GenericQueryMessage
extends MessageDecorator
implements QueryMessage {
    private final ResponseType<?> responseType;

    public GenericQueryMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull ResponseType<?> responseType) {
        this(new GenericMessage(type, payload, Metadata.emptyInstance()), responseType);
    }

    public GenericQueryMessage(@Nonnull Message delegate, @Nonnull ResponseType<?> responseType) {
        super(delegate);
        this.responseType = responseType;
    }

    @Override
    @Nonnull
    public ResponseType<?> responseType() {
        return this.responseType;
    }

    @Override
    @Nonnull
    public QueryMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().withMetadata(metadata), this.responseType);
    }

    @Override
    @Nonnull
    public QueryMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().andMetadata(metadata), this.responseType);
    }

    @Override
    @Nonnull
    public QueryMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, delegate.metadata());
        return new GenericQueryMessage(converted, this.responseType);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", expectedResponseType='").append(this.responseType()).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericQueryMessage";
    }
}

