/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.Converter;

public class ConvertingResponseMessage<R>
implements QueryResponseMessage {
    private final ResponseType<R> expectedResponseType;
    private final QueryResponseMessage responseMessage;

    public ConvertingResponseMessage(ResponseType<R> expectedResponseType, QueryResponseMessage responseMessage) {
        this.expectedResponseType = expectedResponseType;
        this.responseMessage = responseMessage;
    }

    @Override
    public boolean isExceptional() {
        return this.responseMessage.isExceptional();
    }

    @Override
    public Optional<Throwable> optionalExceptionResult() {
        return this.responseMessage.optionalExceptionResult();
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.responseMessage.identifier();
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.responseMessage.type();
    }

    @Override
    @Nonnull
    public Metadata metadata() {
        return this.responseMessage.metadata();
    }

    @Nullable
    public R payload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.optionalExceptionResult().orElse(null));
        }
        return this.expectedResponseType.convert(this.responseMessage.payload());
    }

    @Override
    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.optionalExceptionResult().orElse(null));
        }
        return this.responseMessage.payloadAs(type, converter);
    }

    @Nonnull
    public Class<R> payloadType() {
        return this.expectedResponseType.responseMessagePayloadType();
    }

    @Override
    @Nonnull
    public QueryResponseMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new ConvertingResponseMessage<R>(this.expectedResponseType, (QueryResponseMessage)this.responseMessage.withMetadata((Map)metadata));
    }

    @Override
    @Nonnull
    public QueryResponseMessage andMetadata(@Nonnull Map<String, String> additionalMetadata) {
        return new ConvertingResponseMessage<R>(this.expectedResponseType, (QueryResponseMessage)this.responseMessage.andMetadata((Map)additionalMetadata));
    }

    @Override
    @Nonnull
    public QueryResponseMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        return this.responseMessage.withConvertedPayload(type, converter);
    }
}

