/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.TypeReference;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LazyInitializedComponentDefinition;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.interceptors.HandlerInterceptorRegistry;
import org.axonframework.queryhandling.QueryMessage;

@Internal
public class DefaultHandlerInterceptorRegistry
implements HandlerInterceptorRegistry {
    private static final TypeReference<MessageHandlerInterceptor<Message>> MESSAGE_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<Message>>(){};
    private static final TypeReference<MessageHandlerInterceptor<CommandMessage>> COMMAND_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<CommandMessage>>(){};
    private static final TypeReference<MessageHandlerInterceptor<EventMessage>> EVENT_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<EventMessage>>(){};
    private static final TypeReference<MessageHandlerInterceptor<QueryMessage>> QUERY_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<QueryMessage>>(){};
    private final List<ComponentDefinition<MessageHandlerInterceptor<CommandMessage>>> commandInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<CommandMessage>>>();
    private final List<ComponentDefinition<MessageHandlerInterceptor<EventMessage>>> eventInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<EventMessage>>>();
    private final List<ComponentDefinition<MessageHandlerInterceptor<QueryMessage>>> queryInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<QueryMessage>>>();

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<Message>> interceptorBuilder) {
        GenericInterceptorDefinition genericInterceptorDef = new GenericInterceptorDefinition(interceptorBuilder);
        this.registerCommandInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((CommandMessage)m, c));
        });
        this.registerEventInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((EventMessage)m, c));
        });
        this.registerQueryInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((QueryMessage)m, c));
        });
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerCommandInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.commandInterceptorDefinitions.add(ComponentDefinition.ofType(COMMAND_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerEventInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super EventMessage>> interceptorBuilder) {
        this.eventInterceptorDefinitions.add(ComponentDefinition.ofType(EVENT_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerQueryInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.queryInterceptorDefinitions.add(ComponentDefinition.ofType(QUERY_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<CommandMessage>> commandInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageHandlerInterceptor<CommandMessage>> commandHandlerInterceptors = new ArrayList<MessageHandlerInterceptor<CommandMessage>>();
        for (ComponentDefinition<MessageHandlerInterceptor<CommandMessage>> interceptorBuilder : this.commandInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageHandlerInterceptor handlerInterceptor = (MessageHandlerInterceptor)creator.createComponent().resolve(config);
            commandHandlerInterceptors.add(handlerInterceptor);
        }
        return commandHandlerInterceptors;
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<EventMessage>> eventInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageHandlerInterceptor<EventMessage>> eventHandlerInterceptors = new ArrayList<MessageHandlerInterceptor<EventMessage>>();
        for (ComponentDefinition<MessageHandlerInterceptor<EventMessage>> interceptorBuilder : this.eventInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageHandlerInterceptor handlerInterceptor = (MessageHandlerInterceptor)creator.createComponent().resolve(config);
            eventHandlerInterceptors.add(handlerInterceptor);
        }
        return eventHandlerInterceptors;
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<QueryMessage>> queryInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageHandlerInterceptor<QueryMessage>> queryHandlerInterceptors = new ArrayList<MessageHandlerInterceptor<QueryMessage>>();
        for (ComponentDefinition<MessageHandlerInterceptor<QueryMessage>> interceptorBuilder : this.queryInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageHandlerInterceptor handlerInterceptor = (MessageHandlerInterceptor)creator.createComponent().resolve(config);
            queryHandlerInterceptors.add(handlerInterceptor);
        }
        return queryHandlerInterceptors;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandHandlerInterceptors", this.commandInterceptorDefinitions);
        descriptor.describeProperty("eventHandlerInterceptors", this.eventInterceptorDefinitions);
        descriptor.describeProperty("queryHandlerInterceptors", this.queryInterceptorDefinitions);
    }

    private static class GenericInterceptorDefinition
    extends LazyInitializedComponentDefinition<MessageHandlerInterceptor<Message>, MessageHandlerInterceptor<Message>> {
        public GenericInterceptorDefinition(ComponentBuilder<MessageHandlerInterceptor<Message>> builder) {
            super(new Component.Identifier<MessageHandlerInterceptor<Message>>(MESSAGE_INTERCEPTOR_TYPE_REF, null), builder);
        }
    }
}

