/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.axonframework.common.annotations.PriorityAnnotationComparator;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;

public class MultiParameterResolverFactory
implements ParameterResolverFactory {
    private final ParameterResolverFactory[] factories;

    public static MultiParameterResolverFactory ordered(ParameterResolverFactory ... delegates) {
        return MultiParameterResolverFactory.ordered(Arrays.asList(delegates));
    }

    public static MultiParameterResolverFactory ordered(List<ParameterResolverFactory> delegates) {
        return new MultiParameterResolverFactory(MultiParameterResolverFactory.flatten(delegates));
    }

    public MultiParameterResolverFactory(ParameterResolverFactory ... delegates) {
        this.factories = Arrays.copyOf(delegates, delegates.length);
    }

    public MultiParameterResolverFactory(List<ParameterResolverFactory> delegates) {
        this.factories = delegates.toArray(new ParameterResolverFactory[0]);
    }

    private static ParameterResolverFactory[] flatten(List<ParameterResolverFactory> factories) {
        ArrayList<ParameterResolverFactory> flattened = new ArrayList<ParameterResolverFactory>(factories.size());
        for (ParameterResolverFactory parameterResolverFactory : factories) {
            if (parameterResolverFactory instanceof MultiParameterResolverFactory) {
                flattened.addAll(((MultiParameterResolverFactory)parameterResolverFactory).getDelegates());
                continue;
            }
            flattened.add(parameterResolverFactory);
        }
        flattened.sort(PriorityAnnotationComparator.getInstance());
        return flattened.toArray(new ParameterResolverFactory[0]);
    }

    public List<ParameterResolverFactory> getDelegates() {
        return Arrays.asList(this.factories);
    }

    @Override
    @Nullable
    public ParameterResolver<?> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        for (ParameterResolverFactory factory : this.factories) {
            ParameterResolver<?> resolver = factory.createInstance(executable, parameters, parameterIndex);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }
}

