/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.axonframework.common.annotations.PriorityAnnotationComparator;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;

public class MultiHandlerEnhancerDefinition
implements HandlerEnhancerDefinition {
    private final HandlerEnhancerDefinition[] enhancers;

    public static MultiHandlerEnhancerDefinition ordered(HandlerEnhancerDefinition ... delegates) {
        return MultiHandlerEnhancerDefinition.ordered(Arrays.asList(delegates));
    }

    public static MultiHandlerEnhancerDefinition ordered(Collection<HandlerEnhancerDefinition> delegates) {
        return new MultiHandlerEnhancerDefinition(MultiHandlerEnhancerDefinition.flatten(delegates));
    }

    public MultiHandlerEnhancerDefinition(HandlerEnhancerDefinition ... delegates) {
        this.enhancers = Arrays.copyOf(delegates, delegates.length);
    }

    public MultiHandlerEnhancerDefinition(Collection<HandlerEnhancerDefinition> delegates) {
        this.enhancers = delegates.toArray(new HandlerEnhancerDefinition[delegates.size()]);
    }

    private static HandlerEnhancerDefinition[] flatten(Collection<HandlerEnhancerDefinition> enhancers) {
        ArrayList<HandlerEnhancerDefinition> flattened = new ArrayList<HandlerEnhancerDefinition>(enhancers.size());
        for (HandlerEnhancerDefinition handlerEnhancer : enhancers) {
            if (handlerEnhancer instanceof MultiHandlerEnhancerDefinition) {
                flattened.addAll(((MultiHandlerEnhancerDefinition)handlerEnhancer).getDelegates());
                continue;
            }
            flattened.add(handlerEnhancer);
        }
        flattened.sort(PriorityAnnotationComparator.getInstance());
        return flattened.toArray(new HandlerEnhancerDefinition[flattened.size()]);
    }

    public List<HandlerEnhancerDefinition> getDelegates() {
        return Arrays.asList(this.enhancers);
    }

    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        MessageHandlingMember<T> resolver = original;
        for (HandlerEnhancerDefinition enhancer : this.enhancers) {
            resolver = enhancer.wrapHandler(resolver);
        }
        return resolver;
    }
}

