/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.Optional;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface MessageHandlingMember<T> {
    public Class<?> payloadType();

    default public int priority() {
        return 0;
    }

    public boolean canHandle(@Nonnull Message var1, @Nonnull ProcessingContext var2);

    default public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return true;
    }

    public boolean canHandleMessageType(@Nonnull Class<? extends Message> var1);

    @Deprecated
    public Object handleSync(@Nonnull Message var1, @Nonnull ProcessingContext var2, @Nullable T var3) throws Exception;

    public MessageStream<?> handle(@Nonnull Message var1, @Nonnull ProcessingContext var2, @Nullable T var3);

    public <HT> Optional<HT> unwrap(Class<HT> var1);

    default public Class<?> declaringClass() {
        return this.unwrap(Member.class).map(Member::getDeclaringClass).orElseThrow(() -> new UnsupportedOperationException("This implementation of MessageHandlingMember does not wrap a java.lang.reflect.Member. Please provide a different way of getting 'declaringClass' of this MessageHandlingMember."));
    }

    default public String signature() {
        return this.unwrap(Executable.class).map(Executable::toGenericString).orElse("__unknown__");
    }

    default public <R> Optional<R> attribute(String attributeKey) {
        return Optional.empty();
    }
}

