/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.AbstractMessage;
import org.axonframework.messaging.ConversionCache;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.serialization.ConversionException;
import org.axonframework.serialization.Converter;

public class GenericMessage
extends AbstractMessage {
    private final Object payload;
    private final Class<?> payloadType;
    private final Metadata metadata;
    private final ConversionCache convertedPayloads;

    public GenericMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(type, payload, Metadata.emptyInstance());
    }

    public GenericMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metadata) {
        this(type, payload, GenericMessage.getDeclaredPayloadType(payload), metadata);
    }

    public <P> GenericMessage(@Nonnull MessageType type, @Nullable P payload, @Nonnull Class<P> declaredPayloadType, @Nonnull Map<String, ?> metadata) {
        this(IdentifierFactory.getInstance().generateIdentifier(), type, payload, declaredPayloadType, CurrentUnitOfWork.correlationData().mergedWith(Metadata.from(metadata)));
    }

    public GenericMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metadata) {
        this(identifier, type, payload, GenericMessage.getDeclaredPayloadType(payload), metadata);
    }

    public <P> GenericMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable P payload, @Nonnull Class<P> declaredPayloadType, @Nonnull Map<String, String> metadata) {
        super(identifier, type);
        this.payload = payload;
        this.payloadType = declaredPayloadType;
        this.metadata = Metadata.from(metadata);
        this.convertedPayloads = new ConversionCache(payload);
    }

    private GenericMessage(@Nonnull GenericMessage original, @Nonnull Metadata metadata) {
        super(original.identifier(), original.type());
        this.payload = original.payload();
        this.payloadType = original.payloadType();
        this.metadata = metadata;
        this.convertedPayloads = new ConversionCache(this.payload);
    }

    private static <T> Class<T> getDeclaredPayloadType(@Nullable T payload) {
        return ObjectUtils.nullSafeTypeOf(payload);
    }

    public static Message emptyMessage() {
        return new GenericMessage(new MessageType("empty"), null);
    }

    @Override
    @Nullable
    public Object payload() {
        return this.payload;
    }

    @Override
    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isAssignableFrom(this.payloadType()) || Void.class.equals(this.payloadType())) {
            return (T)this.payload();
        }
        if (converter == null) {
            throw new ConversionException("Cannot convert " + String.valueOf(this.payloadType()) + " to " + String.valueOf(type) + " without a converter.");
        }
        return this.convertedPayloads.convertIfAbsent(type, converter);
    }

    @Override
    @Nonnull
    public Class<?> payloadType() {
        return this.payloadType;
    }

    @Override
    @Nonnull
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    @Nonnull
    protected Message withMetadata(Metadata metadata) {
        return new GenericMessage(this, metadata);
    }

    @Override
    @Nonnull
    public Message withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        return ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType()) ? this : new GenericMessage(this.identifier(), this.type(), convertedPayload, this.metadata());
    }
}

