/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiFunction;
import org.axonframework.common.annotations.Internal;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageDispatchInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class DefaultMessageDispatchInterceptorChain<M extends Message>
implements MessageDispatchInterceptorChain<M> {
    private final BiFunction<? super M, ProcessingContext, MessageStream<?>> interceptingDispatcher;

    public DefaultMessageDispatchInterceptorChain(@Nonnull Collection<MessageDispatchInterceptor<? super M>> interceptors) {
        this(interceptors, (message, processingContext) -> MessageStream.just(message).cast());
    }

    public DefaultMessageDispatchInterceptorChain(@Nonnull Collection<MessageDispatchInterceptor<? super M>> interceptors, @Nonnull BiFunction<? super M, ProcessingContext, MessageStream<?>> terminal) {
        Iterator<MessageDispatchInterceptor<M>> interceptorIterator = new LinkedList<MessageDispatchInterceptor<M>>(interceptors).descendingIterator();
        InterceptingDispatcher interceptingDispatcher = Objects.requireNonNull(terminal, "The terminal operation may not be null.");
        while (interceptorIterator.hasNext()) {
            interceptingDispatcher = new InterceptingDispatcher(this, interceptorIterator.next(), interceptingDispatcher);
        }
        this.interceptingDispatcher = interceptingDispatcher;
    }

    @Override
    @Nonnull
    public MessageStream<?> proceed(@Nonnull M message, @Nullable ProcessingContext context) {
        return this.interceptingDispatcher.apply(message, context);
    }

    private class InterceptingDispatcher
    implements MessageDispatchInterceptorChain<M>,
    BiFunction<M, ProcessingContext, MessageStream<?>> {
        private final MessageDispatchInterceptor<? super M> interceptor;
        private final BiFunction<? super M, ProcessingContext, MessageStream<?>> next;

        private InterceptingDispatcher(DefaultMessageDispatchInterceptorChain defaultMessageDispatchInterceptorChain, MessageDispatchInterceptor<? super M> interceptor, BiFunction<? super M, ProcessingContext, MessageStream<?>> next) {
            this.interceptor = interceptor;
            this.next = next;
        }

        @Override
        @Nonnull
        public MessageStream<?> proceed(@Nonnull M message, @Nullable ProcessingContext context) {
            return this.next.apply(message, context);
        }

        @Override
        public MessageStream<?> apply(M message, ProcessingContext context) {
            try {
                return this.interceptor.interceptOnDispatch(message, context, this);
            }
            catch (RuntimeException e) {
                return MessageStream.failed(e);
            }
        }
    }
}

