/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token.store.jdbc;

public class TokenSchema {
    private final String tokenTable;
    private final String processorNameColumn;
    private final String segmentColumn;
    private final String tokenColumn;
    private final String tokenTypeColumn;
    private final String timestampColumn;
    private final String ownerColumn;

    public TokenSchema() {
        this(TokenSchema.builder());
    }

    private TokenSchema(Builder builder) {
        this.tokenTable = builder.tokenTable;
        this.processorNameColumn = builder.processorNameColumn;
        this.segmentColumn = builder.segmentColumn;
        this.tokenColumn = builder.tokenColumn;
        this.tokenTypeColumn = builder.tokenTypeColumn;
        this.timestampColumn = builder.timestampColumn;
        this.ownerColumn = builder.ownerColumn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String tokenTable() {
        return this.tokenTable;
    }

    public String processorNameColumn() {
        return this.processorNameColumn;
    }

    public String segmentColumn() {
        return this.segmentColumn;
    }

    public String tokenColumn() {
        return this.tokenColumn;
    }

    public String tokenTypeColumn() {
        return this.tokenTypeColumn;
    }

    public String timestampColumn() {
        return this.timestampColumn;
    }

    public String ownerColumn() {
        return this.ownerColumn;
    }

    public static class Builder {
        private String tokenTable = "TokenEntry";
        private String processorNameColumn = "processorName";
        private String segmentColumn = "segment";
        private String tokenColumn = "token";
        private String tokenTypeColumn = "tokenType";
        private String timestampColumn = "timestamp";
        private String ownerColumn = "owner";

        public Builder setTokenTable(String tokenTable) {
            this.tokenTable = tokenTable;
            return this;
        }

        public Builder setProcessorNameColumn(String columnName) {
            this.processorNameColumn = columnName;
            return this;
        }

        public Builder setSegmentColumn(String columnName) {
            this.segmentColumn = columnName;
            return this;
        }

        public Builder setTokenColumn(String columnName) {
            this.tokenColumn = columnName;
            return this;
        }

        public Builder setTokenTypeColumn(String columnName) {
            this.tokenTypeColumn = columnName;
            return this;
        }

        public Builder setTimestampColumn(String columnName) {
            this.timestampColumn = columnName;
            return this;
        }

        public Builder setOwnerColumn(String columnName) {
            this.ownerColumn = columnName;
            return this;
        }

        public TokenSchema build() {
            return new TokenSchema(this);
        }
    }
}

