/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token.store;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.axonframework.common.FutureUtils;
import org.axonframework.eventhandling.processors.streaming.segmenting.Segment;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.processors.streaming.token.store.UnableToClaimTokenException;
import org.axonframework.eventhandling.processors.streaming.token.store.UnableToInitializeTokenException;
import org.axonframework.eventhandling.processors.streaming.token.store.UnableToRetrieveIdentifierException;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface TokenStore {
    @Nonnull
    default public CompletableFuture<Void> initializeTokenSegments(@Nonnull String processorName, int segmentCount, @Nullable TrackingToken initialToken, @Nullable ProcessingContext context) throws UnableToClaimTokenException {
        try {
            for (int segment = 0; segment < segmentCount; ++segment) {
                FutureUtils.joinAndUnwrap(this.storeToken(initialToken, processorName, segment, context));
                this.releaseClaim(processorName, segment, context).join();
            }
            return FutureUtils.emptyCompletedFuture();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Nonnull
    public CompletableFuture<Void> storeToken(@Nullable TrackingToken var1, @Nonnull String var2, int var3, @Nullable ProcessingContext var4) throws UnableToClaimTokenException;

    @Nonnull
    public CompletableFuture<TrackingToken> fetchToken(@Nonnull String var1, int var2, @Nullable ProcessingContext var3) throws UnableToClaimTokenException;

    @Nonnull
    default public CompletableFuture<TrackingToken> fetchToken(@Nonnull String processorName, @Nonnull Segment segment, @Nullable ProcessingContext context) throws UnableToClaimTokenException {
        return this.fetchToken(processorName, segment.getSegmentId(), context);
    }

    @Nonnull
    default public CompletableFuture<Void> extendClaim(@Nonnull String processorName, int segment, @Nullable ProcessingContext context) throws UnableToClaimTokenException {
        return this.fetchToken(processorName, segment, context).thenRun(() -> {});
    }

    @Nonnull
    public CompletableFuture<Void> releaseClaim(@Nonnull String var1, int var2, @Nullable ProcessingContext var3);

    @Nonnull
    public CompletableFuture<Void> initializeSegment(@Nullable TrackingToken var1, @Nonnull String var2, int var3, @Nullable ProcessingContext var4) throws UnableToInitializeTokenException;

    @Nonnull
    public CompletableFuture<Void> deleteToken(@Nonnull String var1, int var2, @Nullable ProcessingContext var3) throws UnableToClaimTokenException;

    @Nonnull
    public CompletableFuture<int[]> fetchSegments(@Nonnull String var1, @Nullable ProcessingContext var2);

    @Nonnull
    default public CompletableFuture<List<Segment>> fetchAvailableSegments(@Nonnull String processorName, @Nullable ProcessingContext context) {
        return this.fetchSegments(processorName, context).thenApply(segments -> Arrays.stream(segments).boxed().map(segment -> Segment.computeSegment(segment, segments)).collect(Collectors.toList()));
    }

    @Nonnull
    default public CompletableFuture<Optional<String>> retrieveStorageIdentifier(@Nullable ProcessingContext context) throws UnableToRetrieveIdentifierException {
        return CompletableFuture.completedFuture(Optional.empty());
    }
}

