/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.segmenting.SequencingEventHandlingComponent;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class ProcessorEventHandlingComponents {
    private final List<? extends EventHandlingComponent> components;

    public ProcessorEventHandlingComponents(@Nonnull List<EventHandlingComponent> components) {
        Objects.requireNonNull(components, "Components may not be null");
        this.components = components.stream().map(c -> c instanceof SequencingEventHandlingComponent ? c : new SequencingEventHandlingComponent((EventHandlingComponent)c)).toList();
    }

    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull List<? extends EventMessage> events, @Nonnull ProcessingContext context) {
        MessageStream batchResult = MessageStream.empty().cast();
        for (EventMessage eventMessage : events) {
            MessageStream.Empty<Message> eventResult = this.handle(eventMessage, context);
            batchResult = batchResult.concatWith(eventResult.cast());
        }
        return batchResult.ignoreEntries().cast();
    }

    @Nonnull
    private MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        MessageStream<Message> result = MessageStream.empty();
        for (EventHandlingComponent eventHandlingComponent : this.components) {
            if (!eventHandlingComponent.supports(event.type().qualifiedName())) continue;
            MessageStream.Empty<Message> componentResult = eventHandlingComponent.handle(event, context);
            result = result.concatWith(componentResult);
        }
        return result.ignoreEntries().cast();
    }

    public Set<QualifiedName> supportedEvents() {
        return this.components.stream().flatMap(c -> c.supportedEvents().stream()).collect(Collectors.toSet());
    }

    public boolean supports(@Nonnull QualifiedName eventName) {
        return this.components.stream().anyMatch(c -> c.supports(eventName));
    }

    public Set<Object> sequenceIdentifiersFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.components.stream().map(c -> c.sequenceIdentifierFor(event, context)).collect(Collectors.toSet());
    }
}

