/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotations;

import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import org.axonframework.common.Priority;
import org.axonframework.common.annotations.AnnotationUtils;

public class PriorityAnnotationComparator<T>
implements Comparator<T> {
    private static final PriorityAnnotationComparator INSTANCE = new PriorityAnnotationComparator();

    public static <T> PriorityAnnotationComparator<T> getInstance() {
        return INSTANCE;
    }

    private PriorityAnnotationComparator() {
    }

    @Override
    public int compare(T o1, T o2) {
        return Integer.compare(this.getPriority(o2.getClass()), this.getPriority(o1.getClass()));
    }

    private int getPriority(AnnotatedElement annotatedElement) {
        return AnnotationUtils.findAnnotationAttributes(annotatedElement, Priority.class).map(m -> (int)((Integer)m.get("priority"))).orElse(0);
    }
}

