/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface CommandGateway
extends DescribableComponent {
    default public <R> CompletableFuture<R> send(@Nonnull Object command, @Nullable ProcessingContext context, @Nonnull Class<R> resultType) {
        return this.send(command, context).resultAs(resultType);
    }

    default public void sendAndWait(@Nonnull Object command) {
        try {
            this.send(command, null).getResultMessage().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandExecutionException("Thread interrupted while waiting for result", e);
        }
        catch (ExecutionException e) {
            throw CommandGateway.rethrowUnwrappedExecutionException(e);
        }
    }

    default public <R> R sendAndWait(@Nonnull Object command, @Nonnull Class<R> resultType) {
        try {
            return this.send(command, null).resultAs(resultType).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandExecutionException("Thread interrupted while waiting for result", e);
        }
        catch (ExecutionException e) {
            throw CommandGateway.rethrowUnwrappedExecutionException(e);
        }
    }

    public CommandResult send(@Nonnull Object var1, @Nullable ProcessingContext var2);

    public CommandResult send(@Nonnull Object var1, @Nonnull Metadata var2, @Nullable ProcessingContext var3);

    private static RuntimeException rethrowUnwrappedExecutionException(@Nonnull ExecutionException executionException) {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        throwable = executionException.getCause();
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        throw new CommandExecutionException("Checked exception while handling command.", executionException.getCause());
    }
}

