/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring.interception;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageDispatchInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.monitoring.MessageMonitor;

public class MonitoringEventDispatchInterceptor
implements MessageDispatchInterceptor<EventMessage> {
    private final MessageMonitor<? super EventMessage> messageMonitor;

    public MonitoringEventDispatchInterceptor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull EventMessage message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<EventMessage> interceptorChain) {
        if (context != null && context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

